/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.MohistMC;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.entity.CraftCustomEntity;
import com.mohistmc.util.MohistEnumHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_16_R3.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.permissions.DefaultPermissions;

public class ForgeInjectBukkit {
    public static BiMap<RegistryKey<DimensionType>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)DimensionType.field_235999_c_, (Object)World.Environment.NORMAL).put((Object)DimensionType.field_236000_d_, (Object)World.Environment.NETHER).put((Object)DimensionType.field_236001_e_, (Object)World.Environment.THE_END).build());
    public static Map<Villager.Profession, ResourceLocation> profession = new HashMap<Villager.Profession, ResourceLocation>();
    public static Map<Attribute, ResourceLocation> attributemap = new HashMap<Attribute, ResourceLocation>();
    public static Map<PaintingType, Art> artMap = new HashMap<PaintingType, Art>();

    public static void init() {
        ForgeInjectBukkit.addEnumMaterialInItems();
        ForgeInjectBukkit.addEnumMaterialsInBlocks();
        ForgeInjectBukkit.addEnumBiome();
        ForgeInjectBukkit.addEnumEnchantment();
        ForgeInjectBukkit.addEnumPotion();
        ForgeInjectBukkit.addEnumPattern();
        ForgeInjectBukkit.addEnumEntity();
        ForgeInjectBukkit.addEnumVillagerProfession();
        ForgeInjectBukkit.addEnumAttribute();
        ForgeInjectBukkit.addEnumArt();
    }

    public static void addEnumMaterialInItems() {
        for (Map.Entry<RegistryKey<Item>, Item> entry : ForgeRegistries.ITEMS.getEntries()) {
            ResourceLocation resourceLocation = entry.getValue().getRegistryName();
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            String materialName = ForgeInjectBukkit.normalizeName(entry.getKey().toString()).replace("RESOURCEKEYMINECRAFT_ITEM__", "");
            Item item = entry.getValue();
            int id = Item.func_150891_b((Item)item);
            Material material = Material.addMaterial(materialName, id, false, resourceLocation.func_110624_b());
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            if (material == null) continue;
            MohistMC.LOGGER.debug("Save-ITEM: " + material.name() + " - " + materialName);
        }
    }

    public static void addEnumMaterialsInBlocks() {
        for (Map.Entry<RegistryKey<Block>, Block> entry : ForgeRegistries.BLOCKS.getEntries()) {
            ResourceLocation resourceLocation = entry.getValue().getRegistryName();
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            String materialName = ForgeInjectBukkit.normalizeName(entry.getKey().toString()).replace("RESOURCEKEYMINECRAFT_BLOCK__", "");
            Block block = entry.getValue();
            int id = Item.func_150891_b((Item)block.func_199767_j());
            Material material = Material.addMaterial(materialName, id, true, resourceLocation.func_110624_b());
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            if (material == null) continue;
            MohistMC.LOGGER.debug("Save-BLOCK:" + material.name() + " - " + materialName);
        }
    }

    public static void addEnumEnchantment() {
        for (Map.Entry<RegistryKey<net.minecraft.enchantment.Enchantment>, net.minecraft.enchantment.Enchantment> entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
            Enchantment.registerEnchantment(new CraftEnchantment(entry.getValue()));
        }
        Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumPotion() {
        for (Map.Entry<RegistryKey<Effect>, Effect> entry : ForgeRegistries.POTIONS.getEntries()) {
            CraftPotionEffectType pet = new CraftPotionEffectType(entry.getValue());
            PotionEffectType.registerPotionEffectType(pet);
        }
        PotionEffectType.stopAcceptingRegistrations();
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        for (Map.Entry<RegistryKey<net.minecraft.world.biome.Biome>, net.minecraft.world.biome.Biome> entry : ForgeRegistries.BIOMES.getEntries()) {
            String biomeName = entry.getValue().getRegistryName().func_110624_b();
            if (biomeName.equals("minecraft") || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biome = MohistEnumHelper.addEnum0(Biome.class, biomeName, new Class[0], new Object[0]);
            MohistMC.LOGGER.debug("Save-BIOME:" + biome.name() + " - " + biomeName);
        }
        map.clear();
    }

    public static void addEnumPattern() {
        Map PATTERN_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(PatternType.class, null, "byString");
        for (BannerPattern bannerpattern : BannerPattern.values()) {
            String p_i47246_3_ = bannerpattern.name();
            String hashname = bannerpattern.func_190993_b();
            if (PatternType.getByIdentifier(hashname) != null) continue;
            PatternType patternType = MohistEnumHelper.addEnum0(PatternType.class, p_i47246_3_, new Class[]{String.class}, hashname);
            PATTERN_MAP.put(hashname, patternType);
        }
    }

    public static void addEnumEnvironment() {
        int i = World.Environment.values().length;
        Registry registry = MinecraftServer.getServer().field_240767_f_.func_230520_a_();
        for (Map.Entry entry : registry.func_239659_c_()) {
            RegistryKey key = (RegistryKey)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = ForgeInjectBukkit.normalizeName(key.func_240901_a_().toString());
            int id = i - 1;
            environment1 = MohistEnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
            environment.put((Object)key, (Object)environment1);
            MohistMC.LOGGER.debug("Registered forge DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    public static WorldType addEnumWorldType(String name) {
        WorldType worldType = MohistEnumHelper.addEnum0(WorldType.class, name, new Class[]{String.class}, name);
        Map BY_NAME = (Map)ObfuscationReflectionHelper.getPrivateValue(WorldType.class, null, "BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static void addEnumEntity() {
        Map NAME_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityType.class, null, "NAME_MAP");
        Map ID_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityType.class, null, "ID_MAP");
        for (Map.Entry<RegistryKey<net.minecraft.entity.EntityType<?>>, net.minecraft.entity.EntityType<?>> entity : ForgeRegistries.ENTITIES.getEntries()) {
            ResourceLocation resourceLocation = entity.getValue().getRegistryName();
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            String entityType = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int typeId = entityType.hashCode();
            EntityType bukkitType = MohistEnumHelper.addEnum0(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, entityType.toLowerCase(), CraftCustomEntity.class, typeId, false);
            NAME_MAP.put(entityType.toLowerCase(), bukkitType);
            ID_MAP.put((short)typeId, bukkitType);
            ServerAPI.entityTypeMap.put(entity.getValue(), entityType);
        }
    }

    public static void registerDefaultPermission(String name, DefaultPermissionLevel level, String desc) {
        PermissionDefault permissionDefault;
        switch (level) {
            case ALL: {
                permissionDefault = PermissionDefault.TRUE;
                break;
            }
            case OP: {
                permissionDefault = PermissionDefault.OP;
                break;
            }
            default: {
                permissionDefault = PermissionDefault.FALSE;
            }
        }
        Permission permission = new Permission(name, desc, permissionDefault);
        DefaultPermissions.registerPermission(permission, false);
    }

    public static void addEnumVillagerProfession() {
        for (VillagerProfession villagerProfession : ForgeRegistries.PROFESSIONS) {
            ResourceLocation resourceLocation = villagerProfession.getRegistryName();
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            Villager.Profession vp = MohistEnumHelper.addEnum0(Villager.Profession.class, name, new Class[0], new Object[0]);
            profession.put(vp, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void addEnumAttribute() {
        for (net.minecraft.entity.ai.attributes.Attribute attribute : ForgeRegistries.ATTRIBUTES) {
            ResourceLocation resourceLocation = attribute.getRegistryName();
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.func_110623_a());
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            Attribute ab = MohistEnumHelper.addEnum0(Attribute.class, name, new Class[]{String.class}, resourceLocation.func_110623_a());
            attributemap.put(ab, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge Attribute as Attribute(Bukkit) {}", (Object)ab.name());
        }
    }

    public static void addEnumArt() {
        int i = Art.values().length;
        HashMap BY_NAME = (HashMap)ObfuscationReflectionHelper.getPrivateValue(Art.class, null, "BY_NAME");
        HashMap BY_ID = (HashMap)ObfuscationReflectionHelper.getPrivateValue(Art.class, null, "BY_ID");
        for (PaintingType entry : ForgeRegistries.PAINTING_TYPES) {
            int width = entry.func_200834_b();
            int height = entry.func_200832_c();
            ResourceLocation resourceLocation = entry.getRegistryName();
            if (resourceLocation.func_110624_b().equals("minecraft")) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = i - 1;
            Art art = MohistEnumHelper.addEnum(Art.class, name, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{id, width, height});
            artMap.put(entry, art);
            BY_NAME.put(name, art);
            BY_ID.put(id, art);
            MohistMC.LOGGER.debug("Registered forge PaintingType as Art {}", (Object)art);
            ++i;
        }
    }

    public static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }
}

