/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static void deleteFile(File pFile) {
        if (pFile == null || !pFile.exists()) {
            return;
        }
        if (pFile.isDirectory()) {
            FileUtil.clearDir(pFile);
        }
        if (!pFile.delete()) {
            System.gc();
            pFile.delete();
        }
    }

    public static void clearDir(File pDir) {
        if (!pDir.isDirectory()) {
            return;
        }
        File[] tSubFiles = pDir.listFiles();
        if (tSubFiles != null) {
            for (File sChildFile : tSubFiles) {
                FileUtil.deleteFile(sChildFile);
            }
        }
    }

    public static void createNewFile(File pFile, boolean pReplace) throws IOException {
        File tParent;
        if (pFile == null) {
            return;
        }
        if (pFile.isFile()) {
            if (!pReplace) {
                return;
            }
            FileUtil.deleteFile(pFile);
        }
        if (!(tParent = (pFile = pFile.getAbsoluteFile()).getParentFile()).isDirectory() && !tParent.mkdirs()) {
            throw new IOException("File '" + pFile + "' could not be created");
        }
        pFile.createNewFile();
    }

    public static FileOutputStream openOutputStream(File pFile) throws IOException {
        return FileUtil.openOutputStream(pFile, true);
    }

    public static FileOutputStream openOutputStream(File pFile, boolean pAppend) throws IOException {
        if (!pFile.isFile()) {
            FileUtil.createNewFile(pFile, !pAppend);
        }
        return new FileOutputStream(pFile, pAppend);
    }

    public static FileInputStream openInputStream(File pFile) throws IOException {
        if (!pFile.isFile()) {
            FileUtil.createNewFile(pFile, false);
        }
        return new FileInputStream(pFile);
    }

    public static String readContent(File pFile) throws IOException {
        String string;
        FileInputStream tIPStream = null;
        try {
            tIPStream = FileUtil.openInputStream(pFile);
            string = IOUtil.readContent(tIPStream);
        }
        catch (Throwable throwable) {
            IOUtil.closeStream(tIPStream);
            throw throwable;
        }
        IOUtil.closeStream(tIPStream);
        return string;
    }

    public static byte[] readData(File pFile) throws IOException {
        byte[] byArray;
        FileInputStream tIPStream = null;
        try {
            tIPStream = FileUtil.openInputStream(pFile);
            byArray = IOUtil.readData(tIPStream);
        }
        catch (Throwable throwable) {
            IOUtil.closeStream(tIPStream);
            throw throwable;
        }
        IOUtil.closeStream(tIPStream);
        return byArray;
    }

    public static void writeData(File pFile, byte[] pData) throws IOException {
        FileUtil.writeData(pFile, pData, 0, pData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeData(File pFile, byte[] pData, int pOffest, int pLength) throws IOException {
        FileOutputStream tOStream = null;
        try {
            tOStream = FileUtil.openOutputStream(pFile, false);
            ((OutputStream)tOStream).write(pData, pOffest, pLength);
        }
        catch (Throwable throwable) {
            IOUtil.closeStream(tOStream);
            throw throwable;
        }
        IOUtil.closeStream(tOStream);
    }
}

