/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.worldeditfix;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.Map;
import org.bukkit.Material;

public class WorldEditFix {
    public static void init() {
        for (Material material : Material.values()) {
            if (!material.isForgeBlock()) continue;
            String name = material.getKeyForge().toString();
            if (material.isBlock()) {
                BlockType.REGISTRY.register(name, new BlockType(name, blockState -> {
                    ParserContext context = new ParserContext();
                    context.setPreferringWildcard(true);
                    context.setTryLegacy(false);
                    context.setRestricted(false);
                    try {
                        FuzzyBlockState state = (FuzzyBlockState)((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(BukkitAdapter.adapt(blockState.getBlockType()).createBlockData().getAsString(), context)).toImmutableState();
                        BlockStateHolder<BlockState> defaultState = blockState.getBlockType().getAllStates().get(0);
                        for (Map.Entry<Property<?>, Object> propertyObjectEntry : state.getStates().entrySet()) {
                            defaultState = defaultState.with(propertyObjectEntry.getKey(), propertyObjectEntry.getValue());
                        }
                        return defaultState;
                    }
                    catch (InputParseException e) {
                        return blockState;
                    }
                }));
                continue;
            }
            if (!material.isItem()) continue;
            ItemType.REGISTRY.register(name, new ItemType(name));
        }
    }
}

