/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagType;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@Deprecated
public class AdventureNBTConverter {
    private static final BiMap<Class<? extends Tag>, BinaryTagType<?>> TAG_TYPES = new ImmutableBiMap.Builder().put(ByteArrayTag.class, BinaryTagTypes.BYTE_ARRAY).put(ByteTag.class, BinaryTagTypes.BYTE).put(CompoundTag.class, BinaryTagTypes.COMPOUND).put(DoubleTag.class, BinaryTagTypes.DOUBLE).put(EndTag.class, BinaryTagTypes.END).put(FloatTag.class, BinaryTagTypes.FLOAT).put(IntArrayTag.class, BinaryTagTypes.INT_ARRAY).put(IntTag.class, BinaryTagTypes.INT).put(ListTag.class, BinaryTagTypes.LIST).put(LongArrayTag.class, BinaryTagTypes.LONG_ARRAY).put(LongTag.class, BinaryTagTypes.LONG).put(ShortTag.class, BinaryTagTypes.SHORT).put(StringTag.class, BinaryTagTypes.STRING).build();
    private static final Map<BinaryTagType<?>, Function<BinaryTag, Tag>> CONVERSION;

    public static BinaryTagType<?> getAdventureType(Class<? extends Tag> type) {
        return (BinaryTagType)Objects.requireNonNull(TAG_TYPES.get(type), () -> "Missing entry for " + type);
    }

    public static Class<? extends Tag> getJNBTType(BinaryTagType<?> type) {
        return (Class)Objects.requireNonNull(TAG_TYPES.inverse().get(type), () -> "Missing entry for " + type);
    }

    private AdventureNBTConverter() {
    }

    public static Tag fromAdventure(BinaryTag other) {
        Function<BinaryTag, Tag> conversion = CONVERSION.get(other.type());
        if (conversion == null) {
            throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
        }
        return conversion.apply(other);
    }

    static {
        ImmutableMap.Builder conversion = ImmutableMap.builder();
        block0: for (Map.Entry tag : TAG_TYPES.entrySet()) {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = ((Class)tag.getKey()).getConstructors()) {
                if (c.getParameterCount() != 1 || !BinaryTag.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
                conversion.put(tag.getValue(), binaryTag -> {
                    try {
                        return (Tag)c.newInstance(binaryTag);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw (RuntimeException)e.getCause();
                    }
                });
                continue block0;
            }
        }
        CONVERSION = conversion.build();
    }
}

