/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.sk89q.jnbt.AdventureNBTConverter;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagLike;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.NumberBinaryTag;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Deprecated
public final class ListTag
extends Tag {
    private final ListBinaryTag innerTag;

    public ListTag(Class<? extends Tag> type, List<? extends Tag> value) {
        this(ListBinaryTag.of(AdventureNBTConverter.getAdventureType(type), value.stream().map(BinaryTagLike::asBinaryTag).collect(Collectors.toList())));
    }

    public ListTag(ListBinaryTag adventureTag) {
        this.innerTag = adventureTag;
    }

    @Override
    public ListBinaryTag asBinaryTag() {
        return this.innerTag;
    }

    public Class<? extends Tag> getType() {
        return AdventureNBTConverter.getJNBTType(this.innerTag.elementType());
    }

    @Override
    public List<Tag> getValue() {
        return this.innerTag.stream().map(AdventureNBTConverter::fromAdventure).collect(Collectors.toList());
    }

    public ListTag setValue(List<Tag> list) {
        return new ListTag(this.getType(), list);
    }

    private <T> T accessIfExists(int index, Supplier<T> defaultValue, IntFunction<T> accessor) {
        if (index >= this.innerTag.size()) {
            return defaultValue.get();
        }
        return accessor.apply(index);
    }

    @Nullable
    public Tag getIfExists(int index) {
        return this.accessIfExists(index, () -> null, i -> AdventureNBTConverter.fromAdventure(this.innerTag.get(i)));
    }

    public byte[] getByteArray(int index) {
        return this.accessIfExists(index, () -> new byte[0], this.innerTag::getByteArray);
    }

    public byte getByte(int index) {
        return this.accessIfExists(index, () -> (byte)0, this.innerTag::getByte);
    }

    public double getDouble(int index) {
        return this.accessIfExists(index, () -> 0.0, this.innerTag::getDouble);
    }

    public double asDouble(int index) {
        return this.accessIfExists(index, () -> 0.0, i -> {
            BinaryTag tag = this.innerTag.get(i);
            if (tag instanceof NumberBinaryTag) {
                return ((NumberBinaryTag)tag).doubleValue();
            }
            return 0.0;
        });
    }

    public float getFloat(int index) {
        return this.accessIfExists(index, () -> Float.valueOf(0.0f), this.innerTag::getFloat).floatValue();
    }

    public int[] getIntArray(int index) {
        return this.accessIfExists(index, () -> new int[0], this.innerTag::getIntArray);
    }

    public int getInt(int index) {
        return this.accessIfExists(index, () -> 0, this.innerTag::getInt);
    }

    public int asInt(int index) {
        return this.accessIfExists(index, () -> 0, i -> {
            BinaryTag tag = this.innerTag.get(i);
            if (tag instanceof NumberBinaryTag) {
                return ((NumberBinaryTag)tag).intValue();
            }
            return 0;
        });
    }

    public List<Tag> getList(int index) {
        return this.getListTag(index).getValue();
    }

    public ListTag getListTag(int index) {
        return new ListTag(this.accessIfExists(index, ListBinaryTag::empty, this.innerTag::getList));
    }

    public <T extends Tag> List<T> getList(int index, Class<T> listType) {
        ListTag listTag = this.getListTag(index);
        if (listTag.getType().equals(listType)) {
            return listTag.getValue();
        }
        return Collections.emptyList();
    }

    public long getLong(int index) {
        return this.accessIfExists(index, () -> 0L, this.innerTag::getLong);
    }

    public long asLong(int index) {
        return this.accessIfExists(index, () -> 0L, i -> {
            BinaryTag tag = this.innerTag.get(i);
            if (tag instanceof NumberBinaryTag) {
                return ((NumberBinaryTag)tag).longValue();
            }
            return 0L;
        });
    }

    public short getShort(int index) {
        return this.accessIfExists(index, () -> (short)0, this.innerTag::getShort);
    }

    public String getString(int index) {
        return this.accessIfExists(index, () -> "", this.innerTag::getString);
    }
}

