/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.TagStringIO;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.IOException;
import javax.annotation.Nullable;

public class BaseItem
implements NbtValued {
    private ItemType itemType;
    @Nullable
    private LazyReference<CompoundBinaryTag> nbtData;

    public BaseItem(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType);
        this.itemType = itemType;
    }

    @Deprecated
    public BaseItem(ItemType itemType, @Nullable CompoundTag nbtData) {
        this(itemType, nbtData == null ? null : LazyReference.from(nbtData::asBinaryTag));
    }

    public BaseItem(ItemType itemType, @Nullable LazyReference<CompoundBinaryTag> tag) {
        Preconditions.checkNotNull((Object)itemType);
        this.itemType = itemType;
        this.nbtData = tag;
    }

    public ItemType getType() {
        return this.itemType;
    }

    public void setType(ItemType itemType) {
        this.itemType = itemType;
    }

    @Override
    @Nullable
    public LazyReference<CompoundBinaryTag> getNbtReference() {
        return this.nbtData;
    }

    @Override
    public void setNbtReference(@Nullable LazyReference<CompoundBinaryTag> nbtData) {
        this.nbtData = nbtData;
    }

    public String toString() {
        String nbtString = "";
        LazyReference<CompoundBinaryTag> nbtData = this.nbtData;
        if (nbtData != null) {
            try {
                nbtString = TagStringIO.get().asString(nbtData.getValue());
            }
            catch (IOException e) {
                WorldEdit.logger.error("Failed to serialize NBT of Item", (Throwable)e);
            }
        }
        return this.getType().getId() + nbtString;
    }
}

