/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.DataConverters_1_13_R2_2;
import com.sk89q.worldedit.bukkit.adapter.impl.WorldNativeAccess_v1_13_R2_2;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.Watchdog;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.ByteArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.ByteBinaryTag;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.DoubleBinaryTag;
import com.sk89q.worldedit.util.nbt.EndBinaryTag;
import com.sk89q.worldedit.util.nbt.FloatBinaryTag;
import com.sk89q.worldedit.util.nbt.IntArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.LongArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.LongBinaryTag;
import com.sk89q.worldedit.util.nbt.ShortBinaryTag;
import com.sk89q.worldedit.util.nbt.StringBinaryTag;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.BlockStateBoolean;
import net.minecraft.server.v1_13_R2.BlockStateDirection;
import net.minecraft.server.v1_13_R2.BlockStateEnum;
import net.minecraft.server.v1_13_R2.BlockStateInteger;
import net.minecraft.server.v1_13_R2.BlockStateList;
import net.minecraft.server.v1_13_R2.Blocks;
import net.minecraft.server.v1_13_R2.Chunk;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.EnumDirection;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.IBlockState;
import net.minecraft.server.v1_13_R2.IDataManager;
import net.minecraft.server.v1_13_R2.IMaterial;
import net.minecraft.server.v1_13_R2.INamable;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.IWorldReader;
import net.minecraft.server.v1_13_R2.Item;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.MinecraftServer;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagByte;
import net.minecraft.server.v1_13_R2.NBTTagByteArray;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NBTTagDouble;
import net.minecraft.server.v1_13_R2.NBTTagEnd;
import net.minecraft.server.v1_13_R2.NBTTagFloat;
import net.minecraft.server.v1_13_R2.NBTTagInt;
import net.minecraft.server.v1_13_R2.NBTTagIntArray;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_13_R2.NBTTagLong;
import net.minecraft.server.v1_13_R2.NBTTagLongArray;
import net.minecraft.server.v1_13_R2.NBTTagShort;
import net.minecraft.server.v1_13_R2.NBTTagString;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityStatus;
import net.minecraft.server.v1_13_R2.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_13_R2.PersistentCollection;
import net.minecraft.server.v1_13_R2.SystemUtils;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldData;
import net.minecraft.server.v1_13_R2.WorldNBTStorage;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public final class Spigot_v1_13_R2_2
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField;
    private final Field serverWorldsField;
    private final Method nbtCreateTagMethod;
    private final Watchdog watchdog;
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.NEIGHBORS, (Enum[])new SideEffect[]{SideEffect.LIGHTING, SideEffect.VALIDATION, SideEffect.ENTITY_AI, SideEffect.EVENTS});

    public Spigot_v1_13_R2_2() throws NoSuchFieldException, NoSuchMethodException {
        Watchdog watchdog;
        CraftServer.class.cast(Bukkit.getServer());
        this.nbtListTagListField = NBTTagList.class.getDeclaredField("list");
        this.nbtListTagListField.setAccessible(true);
        this.serverWorldsField = CraftServer.class.getDeclaredField("worlds");
        this.serverWorldsField.setAccessible(true);
        this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
        this.nbtCreateTagMethod.setAccessible(true);
        new NBTTagString("test").asString();
        new DataConverters_1_13_R2_2(CraftMagicNumbers.INSTANCE.getDataVersion(), this).build(ForkJoinPool.commonPool());
        try {
            Class.forName("org.spigotmc.WatchdogThread");
            watchdog = new SpigotWatchdog();
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            try {
                watchdog = new MojangWatchdog(((CraftServer)Bukkit.getServer()).getServer());
            }
            catch (NoSuchFieldException ex) {
                watchdog = null;
            }
        }
        this.watchdog = watchdog;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            SpigotConfig.config.set("world-settings.worldeditregentempworld.verbose", false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public DataFixer getDataFixer() {
        return DataConverters_1_13_R2_2.INSTANCE;
    }

    static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.load(tag);
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.save(tag);
    }

    @Nullable
    private static String getEntityId(net.minecraft.server.v1_13_R2.Entity entity) {
        MinecraftKey minecraftkey = EntityTypes.getName((EntityTypes)entity.getBukkitEntity().getHandle().P());
        return minecraftkey == null ? null : minecraftkey.toString();
    }

    @Nullable
    private static net.minecraft.server.v1_13_R2.Entity createEntityFromId(String id, World world) {
        return EntityTypes.a((World)world, (MinecraftKey)new MinecraftKey(id));
    }

    private static void readTagIntoEntity(NBTTagCompound tag, net.minecraft.server.v1_13_R2.Entity entity) {
        entity.f(tag);
    }

    private static void readEntityIntoTag(net.minecraft.server.v1_13_R2.Entity entity, NBTTagCompound tag) {
        entity.save(tag);
    }

    private static net.minecraft.server.v1_13_R2.Block getBlockFromType(BlockType blockType) {
        return (net.minecraft.server.v1_13_R2.Block)IRegistry.BLOCK.get(MinecraftKey.a((String)blockType.getId()));
    }

    private static Item getItemFromType(ItemType itemType) {
        return (Item)IRegistry.ITEM.get(MinecraftKey.a((String)itemType.getId()));
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        int combinedId = net.minecraft.server.v1_13_R2.Block.getCombinedId((IBlockData)state);
        return combinedId == 0 && state.getBlock() != Blocks.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        net.minecraft.server.v1_13_R2.Block mcBlock = Spigot_v1_13_R2_2.getBlockFromType(state.getBlockType());
        IBlockData newState = mcBlock.getBlockData();
        Map<Property<?>, Object> states = state.getStates();
        newState = this.applyProperties((BlockStateList<net.minecraft.server.v1_13_R2.Block, IBlockData>)mcBlock.getStates(), newState, states);
        int combinedId = net.minecraft.server.v1_13_R2.Block.getCombinedId((IBlockData)newState);
        return combinedId == 0 ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public BaseBlock getBlock(Location location) {
        TileEntity te;
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = craftWorld.getHandle();
        Chunk chunk = handle.getChunkAt(x >> 4, z >> 4);
        IBlockData blockData = chunk.getBlockData(x, y, z);
        int internalId = net.minecraft.server.v1_13_R2.Block.getCombinedId((IBlockData)blockData);
        BlockState state = BlockStateIdAccess.getBlockStateById(internalId);
        if (state == null) {
            Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        if ((te = handle.getTileEntity(new BlockPosition(x, y, z))) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_13_R2_2.readTileEntityIntoTag(te, tag);
            return state.toBaseBlock((CompoundBinaryTag)this.toNative((NBTBase)tag));
        }
        return state.toBaseBlock();
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(org.bukkit.World world) {
        return new WorldNativeAccess_v1_13_R2_2(this, new WeakReference<WorldServer>(((CraftWorld)world).getHandle()));
    }

    private static EnumDirection adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return EnumDirection.NORTH;
            }
            case SOUTH: {
                return EnumDirection.SOUTH;
            }
            case WEST: {
                return EnumDirection.WEST;
            }
            case EAST: {
                return EnumDirection.EAST;
            }
            case DOWN: {
                return EnumDirection.DOWN;
            }
        }
        return EnumDirection.UP;
    }

    private IBlockData applyProperties(BlockStateList<net.minecraft.server.v1_13_R2.Block, IBlockData> stateContainer, IBlockData newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            IBlockState property = stateContainer.a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof BlockStateDirection) {
                Direction dir = (Direction)((Object)value);
                value = Spigot_v1_13_R2_2.adapt(dir);
            } else if (property instanceof BlockStateEnum) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((BlockStateEnum)property).b((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.a() + " does not contain " + enumName);
                }));
            }
            newState = (IBlockData)newState.set(property, value);
        }
        return newState;
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.server.v1_13_R2.Entity mcEntity = craftEntity.getHandle();
        String id = Spigot_v1_13_R2_2.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_13_R2_2.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(com.sk89q.worldedit.world.entity.EntityTypes.get(id), LazyReference.from(() -> (CompoundBinaryTag)this.toNative((NBTBase)tag)));
        }
        return null;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        net.minecraft.server.v1_13_R2.Entity createdEntity = Spigot_v1_13_R2_2.createEntityFromId(state.getType().getId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundBinaryTag nativeTag = state.getNbt();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                Spigot_v1_13_R2_2.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public Component getRichBlockName(BlockType blockType) {
        return TranslatableComponent.of(Spigot_v1_13_R2_2.getBlockFromType(blockType).m());
    }

    @Override
    public Component getRichItemName(ItemType itemType) {
        return TranslatableComponent.of(Spigot_v1_13_R2_2.getItemFromType(itemType).getName());
    }

    @Override
    public Component getRichItemName(BaseItemStack itemStack) {
        return TranslatableComponent.of(CraftItemStack.asNMSCopy((ItemStack)BukkitAdapter.adapt(itemStack)).j());
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap properties = Maps.newTreeMap(String::compareTo);
        net.minecraft.server.v1_13_R2.Block block = Spigot_v1_13_R2_2.getBlockFromType(blockType);
        if (block == null) {
            this.logger.warning("Failed to find properties for " + blockType.getId());
            return properties;
        }
        BlockStateList blockStateList = block.getStates();
        for (IBlockState state : blockStateList.d()) {
            AbstractProperty property;
            if (state instanceof BlockStateBoolean) {
                property = new BooleanProperty(state.a(), (List<Boolean>)ImmutableList.copyOf((Collection)state.d()));
            } else if (state instanceof BlockStateDirection) {
                property = new DirectionalProperty(state.a(), state.d().stream().map(e -> Direction.valueOf(((INamable)e).getName().toUpperCase())).collect(Collectors.toList()));
            } else if (state instanceof BlockStateEnum) {
                property = new EnumProperty(state.a(), state.d().stream().map(e -> ((INamable)e).getName()).collect(Collectors.toList()));
            } else if (state instanceof BlockStateInteger) {
                property = new IntegerProperty(state.a(), (List<Integer>)ImmutableList.copyOf((Collection)state.d()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public void sendFakeNBT(Player player, BlockVector3 pos, CompoundBinaryTag nbtData) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutTileEntityData(new BlockPosition(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, (NBTTagCompound)this.fromNative(nbtData)));
    }

    @Override
    public void sendFakeOP(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityStatus((net.minecraft.server.v1_13_R2.Entity)((CraftPlayer)player).getHandle(), 28));
    }

    @Override
    public boolean canPlaceAt(org.bukkit.World world, BlockVector3 position, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        IBlockData blockData = net.minecraft.server.v1_13_R2.Block.getByCombinedId((int)internalId);
        return blockData.canPlace((IWorldReader)((CraftWorld)world).getHandle(), new BlockPosition(position.getX(), position.getY(), position.getZ()));
    }

    @Override
    public ItemStack adapt(BaseItemStack item) {
        net.minecraft.server.v1_13_R2.ItemStack stack = new net.minecraft.server.v1_13_R2.ItemStack((IMaterial)IRegistry.ITEM.get(MinecraftKey.a((String)item.getType().getId())), item.getAmount());
        stack.setTag((NBTTagCompound)this.fromNative(item.getNbt()));
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_13_R2.ItemStack)stack);
    }

    @Override
    public BaseItemStack adapt(ItemStack itemStack) {
        net.minecraft.server.v1_13_R2.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        BaseItemStack weStack = new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), itemStack.getAmount());
        weStack.setNbt((CompoundBinaryTag)this.toNative((NBTBase)nmsStack.getTag()));
        return weStack;
    }

    @Override
    public boolean regenerate(org.bukkit.World bukkitWorld, Region region, Extent extent, RegenOptions options) {
        WorldServer originalWorld = ((CraftWorld)bukkitWorld).getHandle();
        File saveFolder = Files.createTempDir();
        saveFolder.deleteOnExit();
        saveFolder.deleteOnExit();
        try {
            World.Environment env = bukkitWorld.getEnvironment();
            ChunkGenerator gen = bukkitWorld.getGenerator();
            MinecraftServer server = originalWorld.getServer().getServer();
            WorldData newWorldData = new WorldData(originalWorld.worldData.a((NBTTagCompound)null), server.dataConverterManager, CraftMagicNumbers.INSTANCE.getDataVersion(), null);
            newWorldData.checkName("worldeditregentempworld");
            WorldNBTStorage saveHandler = new WorldNBTStorage(saveFolder, originalWorld.getDataManager().getDirectory().getName(), server, server.dataConverterManager);
            try (WorldServer freshWorld = new WorldServer(server, (IDataManager)saveHandler, new PersistentCollection((IDataManager)saveHandler), newWorldData, originalWorld.worldProvider.getDimensionManager(), originalWorld.methodProfiler, env, gen);){
                freshWorld.savingDisabled = true;
                CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
                for (BlockVector2 chunk : expandedPreGen.getChunks()) {
                    freshWorld.getChunkAt(chunk.getBlockX(), chunk.getBlockZ());
                }
                CraftWorld craftWorld = freshWorld.getWorld();
                BukkitWorld from = new BukkitWorld((org.bukkit.World)craftWorld);
                for (BlockVector3 vec : region) {
                    extent.setBlock(vec, from.getFullBlock(vec));
                }
            }
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
        finally {
            saveFolder.delete();
            try {
                Map map = (Map)this.serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return true;
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    BinaryTag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, BinaryTag> values = new HashMap<String, BinaryTag>();
            Set foreignKeys = ((NBTTagCompound)foreign).getKeys();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return CompoundBinaryTag.from(values);
        }
        if (foreign instanceof NBTTagByte) {
            return ByteBinaryTag.of(((NBTTagByte)foreign).asByte());
        }
        if (foreign instanceof NBTTagByteArray) {
            return ByteArrayBinaryTag.of(((NBTTagByteArray)foreign).c());
        }
        if (foreign instanceof NBTTagDouble) {
            return DoubleBinaryTag.of(((NBTTagDouble)foreign).asDouble());
        }
        if (foreign instanceof NBTTagFloat) {
            return FloatBinaryTag.of(((NBTTagFloat)foreign).asFloat());
        }
        if (foreign instanceof NBTTagInt) {
            return IntBinaryTag.of(((NBTTagInt)foreign).asInt());
        }
        if (foreign instanceof NBTTagIntArray) {
            return IntArrayBinaryTag.of(((NBTTagIntArray)foreign).d());
        }
        if (foreign instanceof NBTTagLongArray) {
            return LongArrayBinaryTag.of(((NBTTagLongArray)foreign).d());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return ListBinaryTag.empty();
            }
        }
        if (foreign instanceof NBTTagLong) {
            return LongBinaryTag.of(((NBTTagLong)foreign).asLong());
        }
        if (foreign instanceof NBTTagShort) {
            return ShortBinaryTag.of(((NBTTagShort)foreign).asShort());
        }
        if (foreign instanceof NBTTagString) {
            return StringBinaryTag.of(foreign.asString());
        }
        if (foreign instanceof NBTTagEnd) {
            return EndBinaryTag.get();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListBinaryTag toNativeList(NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ListBinaryTag.Builder<BinaryTag> values = ListBinaryTag.builder();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(this.toNative(element));
        }
        return values.build();
    }

    NBTBase fromNative(BinaryTag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundBinaryTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (String key : ((CompoundBinaryTag)foreign).keySet()) {
                tag.set(key, this.fromNative(((CompoundBinaryTag)foreign).get(key)));
            }
            return tag;
        }
        if (foreign instanceof ByteBinaryTag) {
            return new NBTTagByte(((ByteBinaryTag)foreign).value());
        }
        if (foreign instanceof ByteArrayBinaryTag) {
            return new NBTTagByteArray(((ByteArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof DoubleBinaryTag) {
            return new NBTTagDouble(((DoubleBinaryTag)foreign).value());
        }
        if (foreign instanceof FloatBinaryTag) {
            return new NBTTagFloat(((FloatBinaryTag)foreign).value());
        }
        if (foreign instanceof IntBinaryTag) {
            return new NBTTagInt(((IntBinaryTag)foreign).value());
        }
        if (foreign instanceof IntArrayBinaryTag) {
            return new NBTTagIntArray(((IntArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof LongArrayBinaryTag) {
            return new NBTTagLongArray(((LongArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof ListBinaryTag) {
            NBTTagList tag = new NBTTagList();
            ListBinaryTag foreignList = (ListBinaryTag)foreign;
            for (BinaryTag t : foreignList) {
                tag.add(this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongBinaryTag) {
            return new NBTTagLong(((LongBinaryTag)foreign).value());
        }
        if (foreign instanceof ShortBinaryTag) {
            return new NBTTagShort(((ShortBinaryTag)foreign).value());
        }
        if (foreign instanceof StringBinaryTag) {
            return new NBTTagString(((StringBinaryTag)foreign).value());
        }
        if (foreign instanceof EndBinaryTag) {
            try {
                return (NBTBase)this.nbtCreateTagMethod.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    @Override
    public boolean supportsWatchdog() {
        return this.watchdog != null;
    }

    @Override
    public void tickWatchdog() {
        this.watchdog.tick();
    }

    private static class MojangWatchdog
    implements Watchdog {
        private final MinecraftServer server;
        private final Field tickField;

        MojangWatchdog(MinecraftServer server) throws NoSuchFieldException {
            this.server = server;
            Field tickField = MinecraftServer.class.getDeclaredField("nextTick");
            tickField.setAccessible(true);
            this.tickField = tickField;
        }

        @Override
        public void tick() {
            try {
                this.tickField.set(this.server, SystemUtils.getMonotonicMillis());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private class SpigotWatchdog
    implements Watchdog {
        private final Field instanceField;
        private final Field lastTickField;

        SpigotWatchdog() throws NoSuchFieldException {
            Field instanceField = WatchdogThread.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            this.instanceField = instanceField;
            Field lastTickField = WatchdogThread.class.getDeclaredField("lastTick");
            lastTickField.setAccessible(true);
            this.lastTickField = lastTickField;
        }

        @Override
        public void tick() {
            try {
                WatchdogThread instance = (WatchdogThread)this.instanceField.get(null);
                if ((Long)this.lastTickField.get(instance) != 0L) {
                    WatchdogThread.tick();
                }
            }
            catch (IllegalAccessException e) {
                Spigot_v1_13_R2_2.this.logger.log(Level.WARNING, "Failed to tick watchdog", e);
            }
        }
    }
}

