/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.DataConverters_1_16_R3;
import com.sk89q.worldedit.bukkit.adapter.impl.FakePlayer_v1_16_R3;
import com.sk89q.worldedit.bukkit.adapter.impl.WorldNativeAccess_v1_16_R3;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.Watchdog;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.ByteArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.ByteBinaryTag;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.DoubleBinaryTag;
import com.sk89q.worldedit.util.nbt.EndBinaryTag;
import com.sk89q.worldedit.util.nbt.FloatBinaryTag;
import com.sk89q.worldedit.util.nbt.IntArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.LongArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.LongBinaryTag;
import com.sk89q.worldedit.util.nbt.ShortBinaryTag;
import com.sk89q.worldedit.util.nbt.StringBinaryTag;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R3.BaseBlockPosition;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.BiomeStorage;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.BlockStateBoolean;
import net.minecraft.server.v1_16_R3.BlockStateDirection;
import net.minecraft.server.v1_16_R3.BlockStateEnum;
import net.minecraft.server.v1_16_R3.BlockStateInteger;
import net.minecraft.server.v1_16_R3.BlockStateList;
import net.minecraft.server.v1_16_R3.Blocks;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkProviderServer;
import net.minecraft.server.v1_16_R3.ChunkStatus;
import net.minecraft.server.v1_16_R3.Convertable;
import net.minecraft.server.v1_16_R3.DedicatedServer;
import net.minecraft.server.v1_16_R3.DynamicOpsNBT;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.GeneratorSettings;
import net.minecraft.server.v1_16_R3.IAsyncTaskHandler;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IBlockState;
import net.minecraft.server.v1_16_R3.IChunkAccess;
import net.minecraft.server.v1_16_R3.IMaterial;
import net.minecraft.server.v1_16_R3.INamable;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.IRegistryCustom;
import net.minecraft.server.v1_16_R3.IResourceManager;
import net.minecraft.server.v1_16_R3.IWorldDataServer;
import net.minecraft.server.v1_16_R3.IWorldReader;
import net.minecraft.server.v1_16_R3.Item;
import net.minecraft.server.v1_16_R3.ItemActionContext;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagByte;
import net.minecraft.server.v1_16_R3.NBTTagByteArray;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagDouble;
import net.minecraft.server.v1_16_R3.NBTTagEnd;
import net.minecraft.server.v1_16_R3.NBTTagFloat;
import net.minecraft.server.v1_16_R3.NBTTagInt;
import net.minecraft.server.v1_16_R3.NBTTagIntArray;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagLong;
import net.minecraft.server.v1_16_R3.NBTTagLongArray;
import net.minecraft.server.v1_16_R3.NBTTagShort;
import net.minecraft.server.v1_16_R3.NBTTagString;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityStatus;
import net.minecraft.server.v1_16_R3.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_16_R3.RegistryReadOps;
import net.minecraft.server.v1_16_R3.ResourceKey;
import net.minecraft.server.v1_16_R3.SystemUtils;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldDataServer;
import net.minecraft.server.v1_16_R3.WorldDimension;
import net.minecraft.server.v1_16_R3.WorldLoadListener;
import net.minecraft.server.v1_16_R3.WorldServer;
import net.minecraft.server.v1_16_R3.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public final class Spigot_v1_16_R3
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField;
    private final Field serverWorldsField;
    private final Method getChunkFutureMethod;
    private final Field chunkProviderExecutorField;
    private final Watchdog watchdog;
    private LoadingCache<WorldServer, FakePlayer_v1_16_R3> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(FakePlayer_v1_16_R3::new));
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.NEIGHBORS, (Enum[])new SideEffect[]{SideEffect.LIGHTING, SideEffect.VALIDATION, SideEffect.ENTITY_AI, SideEffect.EVENTS, SideEffect.UPDATE});

    public Spigot_v1_16_R3() throws NoSuchFieldException, NoSuchMethodException {
        Watchdog watchdog;
        CraftServer.class.cast(Bukkit.getServer());
        int dataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        if (dataVersion != 2584 && dataVersion != 2586) {
            throw new UnsupportedClassVersionError("Not 1.16.4/1.16.5!");
        }
        this.nbtListTagListField = NBTTagList.class.getDeclaredField("list");
        this.nbtListTagListField.setAccessible(true);
        this.serverWorldsField = CraftServer.class.getDeclaredField("worlds");
        this.serverWorldsField.setAccessible(true);
        this.getChunkFutureMethod = ChunkProviderServer.class.getDeclaredMethod("getChunkFutureMainThread", Integer.TYPE, Integer.TYPE, ChunkStatus.class, Boolean.TYPE);
        this.getChunkFutureMethod.setAccessible(true);
        this.chunkProviderExecutorField = ChunkProviderServer.class.getDeclaredField("serverThreadQueue");
        this.chunkProviderExecutorField.setAccessible(true);
        new DataConverters_1_16_R3(CraftMagicNumbers.INSTANCE.getDataVersion(), this).build(ForkJoinPool.commonPool());
        try {
            Class.forName("org.spigotmc.WatchdogThread");
            watchdog = new SpigotWatchdog();
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            try {
                watchdog = new MojangWatchdog(((CraftServer)Bukkit.getServer()).getServer());
            }
            catch (NoSuchFieldException ex) {
                watchdog = null;
            }
        }
        this.watchdog = watchdog;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            SpigotConfig.config.set("world-settings.worldeditregentempworld.verbose", false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public DataFixer getDataFixer() {
        return DataConverters_1_16_R3.INSTANCE;
    }

    static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.load(tileEntity.getBlock(), tag);
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.save(tag);
    }

    @Nullable
    private static String getEntityId(Entity entity) {
        MinecraftKey minecraftkey = net.minecraft.server.v1_16_R3.EntityTypes.getName((net.minecraft.server.v1_16_R3.EntityTypes)entity.getEntityType());
        return minecraftkey == null ? null : minecraftkey.toString();
    }

    @Nullable
    private static Entity createEntityFromId(String id, World world) {
        return net.minecraft.server.v1_16_R3.EntityTypes.a((String)id).map(t -> t.a(world)).orElse(null);
    }

    private static void readTagIntoEntity(NBTTagCompound tag, Entity entity) {
        entity.load(tag);
    }

    private static void readEntityIntoTag(Entity entity, NBTTagCompound tag) {
        entity.save(tag);
    }

    private static Block getBlockFromType(BlockType blockType) {
        return (Block)IRegistry.BLOCK.get(MinecraftKey.a((String)blockType.getId()));
    }

    private static Item getItemFromType(ItemType itemType) {
        return (Item)IRegistry.ITEM.get(MinecraftKey.a((String)itemType.getId()));
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        int combinedId = Block.getCombinedId((IBlockData)state);
        return combinedId == 0 && state.getBlock() != Blocks.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        Block mcBlock = Spigot_v1_16_R3.getBlockFromType(state.getBlockType());
        IBlockData newState = mcBlock.getBlockData();
        Map<Property<?>, Object> states = state.getStates();
        newState = this.applyProperties((BlockStateList<Block, IBlockData>)mcBlock.getStates(), newState, states);
        int combinedId = Block.getCombinedId((IBlockData)newState);
        return combinedId == 0 && state.getBlockType() != BlockTypes.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public BaseBlock getBlock(Location location) {
        TileEntity te;
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = craftWorld.getHandle();
        Chunk chunk = handle.getChunkAt(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData blockData = chunk.getType(blockPos);
        int internalId = Block.getCombinedId((IBlockData)blockData);
        BlockState state = BlockStateIdAccess.getBlockStateById(internalId);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        if ((te = chunk.a(blockPos, Chunk.EnumTileEntityState.CHECK)) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_16_R3.readTileEntityIntoTag(te, tag);
            return state.toBaseBlock((CompoundBinaryTag)this.toNative((NBTBase)tag));
        }
        return state.toBaseBlock();
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(org.bukkit.World world) {
        return new WorldNativeAccess_v1_16_R3(this, new WeakReference<WorldServer>(((CraftWorld)world).getHandle()));
    }

    private static EnumDirection adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return EnumDirection.NORTH;
            }
            case SOUTH: {
                return EnumDirection.SOUTH;
            }
            case WEST: {
                return EnumDirection.WEST;
            }
            case EAST: {
                return EnumDirection.EAST;
            }
            case DOWN: {
                return EnumDirection.DOWN;
            }
        }
        return EnumDirection.UP;
    }

    private IBlockData applyProperties(BlockStateList<Block, IBlockData> stateContainer, IBlockData newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            IBlockState property = stateContainer.a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof BlockStateDirection) {
                Direction dir = (Direction)((Object)value);
                value = Spigot_v1_16_R3.adapt(dir);
            } else if (property instanceof BlockStateEnum) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((BlockStateEnum)property).b((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.getName() + " does not contain " + enumName);
                }));
            }
            newState = (IBlockData)newState.set(property, value);
        }
        return newState;
    }

    @Override
    public BaseEntity getEntity(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        Entity mcEntity = craftEntity.getHandle();
        String id = Spigot_v1_16_R3.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_16_R3.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(EntityTypes.get(id), LazyReference.from(() -> (CompoundBinaryTag)this.toNative((NBTBase)tag)));
        }
        return null;
    }

    @Override
    @Nullable
    public org.bukkit.entity.Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        Entity createdEntity = Spigot_v1_16_R3.createEntityFromId(state.getType().getId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundBinaryTag nativeTag = state.getNbt();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                Spigot_v1_16_R3.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    @Override
    public Component getRichBlockName(BlockType blockType) {
        return TranslatableComponent.of(Spigot_v1_16_R3.getBlockFromType(blockType).i());
    }

    @Override
    public Component getRichItemName(ItemType itemType) {
        return TranslatableComponent.of(Spigot_v1_16_R3.getItemFromType(itemType).getName());
    }

    @Override
    public Component getRichItemName(BaseItemStack itemStack) {
        return TranslatableComponent.of(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)BukkitAdapter.adapt(itemStack)).j());
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap properties = Maps.newTreeMap(String::compareTo);
        Block block = Spigot_v1_16_R3.getBlockFromType(blockType);
        BlockStateList blockStateList = block.getStates();
        for (IBlockState state : blockStateList.d()) {
            AbstractProperty property;
            if (state instanceof BlockStateBoolean) {
                property = new BooleanProperty(state.getName(), (List<Boolean>)ImmutableList.copyOf((Collection)state.getValues()));
            } else if (state instanceof BlockStateDirection) {
                property = new DirectionalProperty(state.getName(), state.getValues().stream().map(e -> Direction.valueOf(((INamable)e).getName().toUpperCase())).collect(Collectors.toList()));
            } else if (state instanceof BlockStateEnum) {
                property = new EnumProperty(state.getName(), state.getValues().stream().map(e -> ((INamable)e).getName()).collect(Collectors.toList()));
            } else if (state instanceof BlockStateInteger) {
                property = new IntegerProperty(state.getName(), (List<Integer>)ImmutableList.copyOf((Collection)state.getValues()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public void sendFakeNBT(Player player, BlockVector3 pos, CompoundBinaryTag nbtData) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutTileEntityData(new BlockPosition(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, (NBTTagCompound)this.fromNative(nbtData)));
    }

    @Override
    public void sendFakeOP(Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityStatus((Entity)((CraftPlayer)player).getHandle(), 28));
    }

    @Override
    public org.bukkit.inventory.ItemStack adapt(BaseItemStack item) {
        ItemStack stack = new ItemStack((IMaterial)IRegistry.ITEM.get(MinecraftKey.a((String)item.getType().getId())), item.getAmount());
        stack.setTag((NBTTagCompound)this.fromNative(item.getNbt()));
        return CraftItemStack.asCraftMirror((ItemStack)stack);
    }

    @Override
    public BaseItemStack adapt(org.bukkit.inventory.ItemStack itemStack) {
        ItemStack nmsStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        BaseItemStack weStack = new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), itemStack.getAmount());
        weStack.setNbt((CompoundBinaryTag)this.toNative((NBTBase)nmsStack.getTag()));
        return weStack;
    }

    @Override
    public boolean simulateItemUse(org.bukkit.World world, BlockVector3 position, BaseItem item, Direction face) {
        FakePlayer_v1_16_R3 fakePlayer;
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer worldServer = craftWorld.getHandle();
        ItemStack stack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)BukkitAdapter.adapt(item instanceof BaseItemStack ? (BaseItemStack)item : new BaseItemStack(item.getType(), LazyReference.from(item::getNbt), 1)));
        stack.setTag((NBTTagCompound)this.fromNative(item.getNbt()));
        try {
            fakePlayer = (FakePlayer_v1_16_R3)((Object)this.fakePlayers.get((Object)worldServer));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.a(EnumHand.MAIN_HAND, stack);
        fakePlayer.setLocation(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPosition blockPos = new BlockPosition(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        Vec3D blockVec = Vec3D.b((BaseBlockPosition)blockPos);
        EnumDirection enumFacing = Spigot_v1_16_R3.adapt(face);
        MovingObjectPositionBlock rayTrace = new MovingObjectPositionBlock(blockVec, enumFacing, blockPos, false);
        ItemActionContext context = new ItemActionContext((EntityHuman)fakePlayer, EnumHand.MAIN_HAND, rayTrace);
        EnumInteractionResult result = stack.placeItem(context, EnumHand.MAIN_HAND);
        if (result != EnumInteractionResult.SUCCESS) {
            result = worldServer.getType(blockPos).interact((World)worldServer, (EntityHuman)fakePlayer, EnumHand.MAIN_HAND, rayTrace).a() ? EnumInteractionResult.SUCCESS : stack.getItem().a((World)worldServer, (EntityHuman)fakePlayer, EnumHand.MAIN_HAND).a();
        }
        return result == EnumInteractionResult.SUCCESS;
    }

    @Override
    public boolean canPlaceAt(org.bukkit.World world, BlockVector3 position, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        IBlockData blockData = Block.getByCombinedId((int)internalId);
        return blockData.canPlace((IWorldReader)((CraftWorld)world).getHandle(), new BlockPosition(position.getX(), position.getY(), position.getZ()));
    }

    @Override
    public boolean regenerate(org.bukkit.World bukkitWorld, Region region, Extent extent, RegenOptions options) {
        try {
            this.doRegen(bukkitWorld, region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(org.bukkit.World bukkitWorld, Region region, Extent extent, RegenOptions options) throws Exception {
        World.Environment env = bukkitWorld.getEnvironment();
        ChunkGenerator gen = bukkitWorld.getGenerator();
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        Convertable convertable = Convertable.a((Path)tempDir);
        ResourceKey<WorldDimension> worldDimKey = this.getWorldDimKey(env);
        try (Convertable.ConversionSession session = convertable.c("worldeditregentempworld", worldDimKey);){
            WorldServer originalWorld = ((CraftWorld)bukkitWorld).getHandle();
            WorldDataServer originalWorldData = originalWorld.worldDataServer;
            long seed = options.getSeed().orElse(originalWorld.getSeed());
            WorldDataServer levelProperties = (WorldDataServer)originalWorld.getServer().getServer().getSaveData();
            RegistryReadOps nbtRegOps = RegistryReadOps.a((DynamicOps)DynamicOpsNBT.a, (IResourceManager)originalWorld.getServer().getServer().dataPackResources.h(), (IRegistryCustom.Dimension)IRegistryCustom.b());
            GeneratorSettings newOpts = (GeneratorSettings)GeneratorSettings.a.encodeStart((DynamicOps)nbtRegOps, (Object)levelProperties.getGeneratorSettings()).flatMap(tag -> GeneratorSettings.a.parse(this.recursivelySetSeed((Dynamic<NBTBase>)new Dynamic((DynamicOps)nbtRegOps, tag), seed, new HashSet<Dynamic<NBTBase>>()))).result().orElseThrow(() -> new IllegalStateException("Unable to map GeneratorOptions"));
            WorldSettings newWorldSettings = new WorldSettings("worldeditregentempworld", originalWorldData.b.getGameType(), originalWorldData.b.hardcore, originalWorldData.b.getDifficulty(), originalWorldData.b.e(), originalWorldData.b.getGameRules(), originalWorldData.b.g());
            WorldDataServer newWorldData = new WorldDataServer(newWorldSettings, newOpts, Lifecycle.stable());
            WorldServer freshWorld = new WorldServer(originalWorld.getMinecraftServer(), originalWorld.getMinecraftServer().executorService, session, (IWorldDataServer)newWorldData, originalWorld.getDimensionKey(), originalWorld.getDimensionManager(), (WorldLoadListener)new NoOpWorldLoadListener(), ((WorldDimension)newOpts.d().a(worldDimKey)).c(), originalWorld.isDebugWorld(), seed, (List)ImmutableList.of(), false, env, gen);
            try {
                this.regenForWorld(region, extent, freshWorld, options);
            }
            finally {
                freshWorld.getChunkProvider().close(false);
            }
        }
        finally {
            try {
                Map map = (Map)this.serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException illegalAccessException) {}
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private Dynamic<NBTBase> recursivelySetSeed(Dynamic<NBTBase> dynamic, long seed, Set<Dynamic<NBTBase>> seen) {
        if (!seen.add(dynamic)) {
            return dynamic;
        }
        return dynamic.updateMapValues(pair -> {
            if (((Dynamic)pair.getFirst()).asString("").equals("seed")) {
                return pair.mapSecond(v -> v.createLong(seed));
            }
            if (((Dynamic)pair.getSecond()).getValue() instanceof NBTTagCompound) {
                return pair.mapSecond(v -> this.recursivelySetSeed((Dynamic<NBTBase>)v, seed, seen));
            }
            return pair;
        });
    }

    private BiomeType adapt(WorldServer serverWorld, BiomeBase origBiome) {
        MinecraftKey key = serverWorld.r().b(IRegistry.ay).getKey((Object)origBiome);
        if (key == null) {
            return null;
        }
        return BiomeTypes.get(key.toString());
    }

    private void regenForWorld(Region region, Extent extent, WorldServer serverWorld, RegenOptions options) throws WorldEditException {
        IAsyncTaskHandler executor;
        List<CompletableFuture<IChunkAccess>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        try {
            executor = (IAsyncTaskHandler)this.chunkProviderExecutorField.get(serverWorld.getChunkProvider());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Couldn't get executor for chunk loading.", e);
        }
        executor.awaitTasks(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<ChunkCoordIntPair, IChunkAccess> chunks = new HashMap<ChunkCoordIntPair, IChunkAccess>();
        for (CompletableFuture<IChunkAccess> future : chunkLoadings) {
            IChunkAccess chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.getPos(), chunk);
        }
        for (BlockVector3 vec : region) {
            BiomeBase origBiome;
            BiomeType adaptedBiome;
            BiomeStorage biomeIndex;
            BlockPosition pos = new BlockPosition(vec.getBlockX(), vec.getBlockY(), vec.getBlockZ());
            IChunkAccess chunk = (IChunkAccess)chunks.get(new ChunkCoordIntPair(pos));
            IBlockData blockData = chunk.getType(pos);
            int internalId = Block.getCombinedId((IBlockData)blockData);
            BlockStateHolder<BlockState> state = BlockStateIdAccess.getBlockStateById(internalId);
            TileEntity blockEntity = chunk.getTileEntity(pos);
            if (blockEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                blockEntity.save(tag);
                state = state.toBaseBlock((CompoundBinaryTag)this.toNative((NBTBase)tag));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes() || (biomeIndex = chunk.getBiomeIndex()) == null || (adaptedBiome = this.adapt(serverWorld, origBiome = biomeIndex.getBiome(vec.getBlockX(), vec.getBlockY(), vec.getBlockZ()))) == null) continue;
            extent.setBiome(vec, adaptedBiome);
        }
    }

    private List<CompletableFuture<IChunkAccess>> submitChunkLoadTasks(Region region, WorldServer serverWorld) {
        ChunkProviderServer chunkManager = serverWorld.getChunkProvider();
        ArrayList<CompletableFuture<IChunkAccess>> chunkLoadings = new ArrayList<CompletableFuture<IChunkAccess>>();
        for (BlockVector2 chunk : region.getChunks()) {
            try {
                chunkLoadings.add((CompletableFuture<IChunkAccess>)((CompletableFuture)this.getChunkFutureMethod.invoke((Object)chunkManager, chunk.getX(), chunk.getZ(), ChunkStatus.FEATURES, true)).thenApply(either -> either.left().orElse(null)));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't load chunk for regen.", e);
            }
        }
        return chunkLoadings;
    }

    private ResourceKey<WorldDimension> getWorldDimKey(World.Environment env) {
        switch (env) {
            case NETHER: {
                return WorldDimension.THE_NETHER;
            }
            case THE_END: {
                return WorldDimension.THE_END;
            }
        }
        return WorldDimension.OVERWORLD;
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    BinaryTag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, BinaryTag> values = new HashMap<String, BinaryTag>();
            Set foreignKeys = ((NBTTagCompound)foreign).getKeys();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return CompoundBinaryTag.from(values);
        }
        if (foreign instanceof NBTTagByte) {
            return ByteBinaryTag.of(((NBTTagByte)foreign).asByte());
        }
        if (foreign instanceof NBTTagByteArray) {
            return ByteArrayBinaryTag.of(((NBTTagByteArray)foreign).getBytes());
        }
        if (foreign instanceof NBTTagDouble) {
            return DoubleBinaryTag.of(((NBTTagDouble)foreign).asDouble());
        }
        if (foreign instanceof NBTTagFloat) {
            return FloatBinaryTag.of(((NBTTagFloat)foreign).asFloat());
        }
        if (foreign instanceof NBTTagInt) {
            return IntBinaryTag.of(((NBTTagInt)foreign).asInt());
        }
        if (foreign instanceof NBTTagIntArray) {
            return IntArrayBinaryTag.of(((NBTTagIntArray)foreign).getInts());
        }
        if (foreign instanceof NBTTagLongArray) {
            return LongArrayBinaryTag.of(((NBTTagLongArray)foreign).getLongs());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return ListBinaryTag.empty();
            }
        }
        if (foreign instanceof NBTTagLong) {
            return LongBinaryTag.of(((NBTTagLong)foreign).asLong());
        }
        if (foreign instanceof NBTTagShort) {
            return ShortBinaryTag.of(((NBTTagShort)foreign).asShort());
        }
        if (foreign instanceof NBTTagString) {
            return StringBinaryTag.of(foreign.asString());
        }
        if (foreign instanceof NBTTagEnd) {
            return EndBinaryTag.get();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListBinaryTag toNativeList(NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ListBinaryTag.Builder<BinaryTag> values = ListBinaryTag.builder();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(this.toNative(element));
        }
        return values.build();
    }

    NBTBase fromNative(BinaryTag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundBinaryTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (String key : ((CompoundBinaryTag)foreign).keySet()) {
                tag.set(key, this.fromNative(((CompoundBinaryTag)foreign).get(key)));
            }
            return tag;
        }
        if (foreign instanceof ByteBinaryTag) {
            return NBTTagByte.a((byte)((ByteBinaryTag)foreign).value());
        }
        if (foreign instanceof ByteArrayBinaryTag) {
            return new NBTTagByteArray(((ByteArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof DoubleBinaryTag) {
            return NBTTagDouble.a((double)((DoubleBinaryTag)foreign).value());
        }
        if (foreign instanceof FloatBinaryTag) {
            return NBTTagFloat.a((float)((FloatBinaryTag)foreign).value());
        }
        if (foreign instanceof IntBinaryTag) {
            return NBTTagInt.a((int)((IntBinaryTag)foreign).value());
        }
        if (foreign instanceof IntArrayBinaryTag) {
            return new NBTTagIntArray(((IntArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof LongArrayBinaryTag) {
            return new NBTTagLongArray(((LongArrayBinaryTag)foreign).value());
        }
        if (foreign instanceof ListBinaryTag) {
            NBTTagList tag = new NBTTagList();
            ListBinaryTag foreignList = (ListBinaryTag)foreign;
            for (BinaryTag t : foreignList) {
                tag.add((Object)this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongBinaryTag) {
            return NBTTagLong.a((long)((LongBinaryTag)foreign).value());
        }
        if (foreign instanceof ShortBinaryTag) {
            return NBTTagShort.a((short)((ShortBinaryTag)foreign).value());
        }
        if (foreign instanceof StringBinaryTag) {
            return NBTTagString.a((String)((StringBinaryTag)foreign).value());
        }
        if (foreign instanceof EndBinaryTag) {
            return NBTTagEnd.b;
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    @Override
    public boolean supportsWatchdog() {
        return this.watchdog != null;
    }

    @Override
    public void tickWatchdog() {
        this.watchdog.tick();
    }

    private static class NoOpWorldLoadListener
    implements WorldLoadListener {
        private NoOpWorldLoadListener() {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair) {
        }

        public void a(ChunkCoordIntPair chunkCoordIntPair, @Nullable ChunkStatus chunkStatus) {
        }

        public void b() {
        }
    }

    private static class MojangWatchdog
    implements Watchdog {
        private final DedicatedServer server;
        private final Field tickField;

        MojangWatchdog(DedicatedServer server) throws NoSuchFieldException {
            this.server = server;
            Field tickField = MinecraftServer.class.getDeclaredField("nextTick");
            tickField.setAccessible(true);
            this.tickField = tickField;
        }

        @Override
        public void tick() {
            try {
                this.tickField.set(this.server, SystemUtils.getMonotonicMillis());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private class SpigotWatchdog
    implements Watchdog {
        private final Field instanceField;
        private final Field lastTickField;

        SpigotWatchdog() throws NoSuchFieldException {
            Field instanceField = WatchdogThread.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            this.instanceField = instanceField;
            Field lastTickField = WatchdogThread.class.getDeclaredField("lastTick");
            lastTickField.setAccessible(true);
            this.lastTickField = lastTickField;
        }

        @Override
        public void tick() {
            try {
                WatchdogThread instance = (WatchdogThread)this.instanceField.get(null);
                if ((Long)this.lastTickField.get(instance) != 0L) {
                    WatchdogThread.tick();
                }
            }
            catch (IllegalAccessException e) {
                Spigot_v1_16_R3.this.logger.log(Level.WARNING, "Failed to tick watchdog", e);
            }
        }
    }
}

