/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.cui;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import javax.annotation.Nullable;

public class ServerCUIHandler {
    private ServerCUIHandler() {
    }

    @Nullable
    public static BaseBlock createStructureBlock(Player player) {
        int length;
        int height;
        int width;
        int posZ;
        int posY;
        int posX;
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(player);
        RegionSelector regionSelector = session.getRegionSelector(player.getWorld());
        if (regionSelector instanceof CuboidRegionSelector) {
            CuboidRegion region;
            if (regionSelector.isDefined()) {
                try {
                    region = ((CuboidRegionSelector)regionSelector).getRegion();
                    posX = region.getMinimumPoint().getBlockX();
                    posY = region.getMinimumPoint().getBlockY();
                    posZ = region.getMinimumPoint().getBlockZ();
                    width = region.getWidth();
                    height = region.getHeight();
                    length = region.getLength();
                }
                catch (IncompleteRegionException e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                BlockVector3 point;
                region = ((CuboidRegionSelector)regionSelector).getIncompleteRegion();
                if (region.getPos1() != null) {
                    point = region.getPos1();
                } else if (region.getPos2() != null) {
                    point = region.getPos2();
                } else {
                    return null;
                }
                posX = point.getBlockX();
                posY = point.getBlockY();
                posZ = point.getBlockZ();
                width = 1;
                height = 1;
                length = 1;
            }
        } else {
            return null;
        }
        if (width > 32 || length > 32 || height > 32) {
            return null;
        }
        Location location = player.getLocation();
        double rotX = location.getYaw();
        double rotY = location.getPitch();
        double xz = Math.cos(Math.toRadians(rotY));
        int x = (int)(location.getX() - -xz * Math.sin(Math.toRadians(rotX)) * 12.0);
        int z = (int)(location.getZ() - xz * Math.cos(Math.toRadians(rotX)) * 12.0);
        int y = Math.max(0, Math.min(Math.min(255, posY + 32), posY + 3));
        CompoundBinaryTag.Builder structureTag = CompoundBinaryTag.builder();
        if (Math.abs(posX -= x) > 32 || Math.abs(posY -= y) > 32 || Math.abs(posZ -= z) > 32) {
            return null;
        }
        structureTag.putString("name", "worldedit:" + player.getName());
        structureTag.putString("author", player.getName());
        structureTag.putString("metadata", "");
        structureTag.putInt("x", x);
        structureTag.putInt("y", y);
        structureTag.putInt("z", z);
        structureTag.putInt("posX", posX);
        structureTag.putInt("posY", posY);
        structureTag.putInt("posZ", posZ);
        structureTag.putInt("sizeX", width);
        structureTag.putInt("sizeY", height);
        structureTag.putInt("sizeZ", length);
        structureTag.putString("rotation", "NONE");
        structureTag.putString("mirror", "NONE");
        structureTag.putString("mode", "SAVE");
        structureTag.putByte("ignoreEntities", (byte)1);
        structureTag.putByte("showboundingbox", (byte)1);
        structureTag.putString("id", BlockTypes.STRUCTURE_BLOCK.getId());
        return BlockTypes.STRUCTURE_BLOCK.getDefaultState().toBaseBlock(structureTag.build());
    }
}

