/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.nbt;

import com.sk89q.worldedit.util.nbt.BinaryTagReaderImpl;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.BinaryTagWriterImpl;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BinaryTagIO {
    private BinaryTagIO() {
    }

    public static @NonNull Reader unlimitedReader() {
        return BinaryTagReaderImpl.UNLIMITED;
    }

    public static @NonNull Reader reader() {
        return BinaryTagReaderImpl.DEFAULT_LIMIT;
    }

    public static @NonNull Reader reader(long sizeLimitBytes) {
        if (sizeLimitBytes <= 0L) {
            throw new IllegalArgumentException("The size limit must be greater than zero");
        }
        return new BinaryTagReaderImpl(sizeLimitBytes);
    }

    public static @NonNull Writer writer() {
        return BinaryTagWriterImpl.INSTANCE;
    }

    @Deprecated
    public static @NonNull CompoundBinaryTag readPath(@NonNull Path path) throws IOException {
        return BinaryTagIO.reader().read(path);
    }

    @Deprecated
    public static @NonNull CompoundBinaryTag readInputStream(@NonNull InputStream input) throws IOException {
        return BinaryTagIO.reader().read(input);
    }

    @Deprecated
    public static @NonNull CompoundBinaryTag readCompressedPath(@NonNull Path path) throws IOException {
        return BinaryTagIO.reader().read(path, Compression.GZIP);
    }

    @Deprecated
    public static @NonNull CompoundBinaryTag readCompressedInputStream(@NonNull InputStream input) throws IOException {
        return BinaryTagIO.reader().read(input, Compression.GZIP);
    }

    @Deprecated
    public static @NonNull CompoundBinaryTag readDataInput(@NonNull DataInput input) throws IOException {
        return BinaryTagIO.reader().read(input);
    }

    @Deprecated
    public static void writePath(@NonNull CompoundBinaryTag tag, @NonNull Path path) throws IOException {
        BinaryTagIO.writer().write(tag, path);
    }

    @Deprecated
    public static void writeOutputStream(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output) throws IOException {
        BinaryTagIO.writer().write(tag, output);
    }

    @Deprecated
    public static void writeCompressedPath(@NonNull CompoundBinaryTag tag, @NonNull Path path) throws IOException {
        BinaryTagIO.writer().write(tag, path, Compression.GZIP);
    }

    @Deprecated
    public static void writeCompressedOutputStream(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output) throws IOException {
        BinaryTagIO.writer().write(tag, output, Compression.GZIP);
    }

    @Deprecated
    public static void writeDataOutput(@NonNull CompoundBinaryTag tag, @NonNull DataOutput output) throws IOException {
        BinaryTagIO.writer().write(tag, output);
    }

    static {
        BinaryTagTypes.COMPOUND.id();
    }

    public static interface Reader {
        default public @NonNull CompoundBinaryTag read(@NonNull Path path) throws IOException {
            return this.read(path, Compression.NONE);
        }

        public @NonNull CompoundBinaryTag read(@NonNull Path var1, @NonNull Compression var2) throws IOException;

        default public @NonNull CompoundBinaryTag read(@NonNull InputStream input) throws IOException {
            return this.read(input, Compression.NONE);
        }

        public @NonNull CompoundBinaryTag read(@NonNull InputStream var1, @NonNull Compression var2) throws IOException;

        public @NonNull CompoundBinaryTag read(@NonNull DataInput var1) throws IOException;

        default public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull Path path) throws IOException {
            return this.readNamed(path, Compression.NONE);
        }

        public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull Path var1, @NonNull Compression var2) throws IOException;

        default public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull InputStream input) throws IOException {
            return this.readNamed(input, Compression.NONE);
        }

        public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull InputStream var1, @NonNull Compression var2) throws IOException;

        public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull DataInput var1) throws IOException;
    }

    public static interface Writer {
        default public void write(@NonNull CompoundBinaryTag tag, @NonNull Path path) throws IOException {
            this.write(tag, path, Compression.NONE);
        }

        public void write(@NonNull CompoundBinaryTag var1, @NonNull Path var2, @NonNull Compression var3) throws IOException;

        default public void write(@NonNull CompoundBinaryTag tag, @NonNull OutputStream output) throws IOException {
            this.write(tag, output, Compression.NONE);
        }

        public void write(@NonNull CompoundBinaryTag var1, @NonNull OutputStream var2, @NonNull Compression var3) throws IOException;

        public void write(@NonNull CompoundBinaryTag var1, @NonNull DataOutput var2) throws IOException;

        default public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> tag, @NonNull Path path) throws IOException {
            this.writeNamed(tag, path, Compression.NONE);
        }

        public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> var1, @NonNull Path var2, @NonNull Compression var3) throws IOException;

        default public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> tag, @NonNull OutputStream output) throws IOException {
            this.writeNamed(tag, output, Compression.NONE);
        }

        public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> var1, @NonNull OutputStream var2, @NonNull Compression var3) throws IOException;

        public void writeNamed( @NonNull Map.Entry<String, CompoundBinaryTag> var1, @NonNull DataOutput var2) throws IOException;
    }

    public static abstract class Compression {
        public static final Compression NONE = new Compression(){

            @Override
            @NonNull InputStream decompress(@NonNull InputStream is) {
                return is;
            }

            @Override
            @NonNull OutputStream compress(@NonNull OutputStream os) {
                return os;
            }

            public String toString() {
                return "Compression.NONE";
            }
        };
        public static final Compression GZIP = new Compression(){

            @Override
            @NonNull InputStream decompress(@NonNull InputStream is) throws IOException {
                return new GZIPInputStream(is);
            }

            @Override
            @NonNull OutputStream compress(@NonNull OutputStream os) throws IOException {
                return new GZIPOutputStream(os);
            }

            public String toString() {
                return "Compression.GZIP";
            }
        };

        abstract @NonNull InputStream decompress(@NonNull InputStream var1) throws IOException;

        abstract @NonNull OutputStream compress(@NonNull OutputStream var1) throws IOException;
    }
}

