/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.nbt;

import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagIO;
import com.sk89q.worldedit.util.nbt.BinaryTagType;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IOStreamUtil;
import com.sk89q.worldedit.util.nbt.TrackingDataInput;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BinaryTagReaderImpl
implements BinaryTagIO.Reader {
    private final long maxBytes;
    static final BinaryTagIO.Reader UNLIMITED = new BinaryTagReaderImpl(-1L);
    static final BinaryTagIO.Reader DEFAULT_LIMIT = new BinaryTagReaderImpl(131082L);

    BinaryTagReaderImpl(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public @NonNull CompoundBinaryTag read(@NonNull Path path, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            CompoundBinaryTag compoundBinaryTag = this.read(is, compression);
            return compoundBinaryTag;
        }
    }

    @Override
    public @NonNull CompoundBinaryTag read(@NonNull InputStream input, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(compression.decompress(IOStreamUtil.closeShield(input))));){
            CompoundBinaryTag compoundBinaryTag = this.read(dis);
            return compoundBinaryTag;
        }
    }

    @Override
    public @NonNull CompoundBinaryTag read(@NonNull DataInput input) throws IOException {
        if (!(input instanceof TrackingDataInput)) {
            input = new TrackingDataInput(input, this.maxBytes);
        }
        BinaryTagType<BinaryTag> type = BinaryTagType.of(input.readByte());
        BinaryTagReaderImpl.requireCompound(type);
        input.skipBytes(input.readUnsignedShort());
        return BinaryTagTypes.COMPOUND.read(input);
    }

    @Override
    public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull Path path, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            Map.Entry<String, CompoundBinaryTag> entry = this.readNamed(is, compression);
            return entry;
        }
    }

    @Override
    public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull InputStream input, @NonNull BinaryTagIO.Compression compression) throws IOException {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(compression.decompress(IOStreamUtil.closeShield(input))));){
            Map.Entry<String, CompoundBinaryTag> entry = this.readNamed(dis);
            return entry;
        }
    }

    @Override
    public  @NonNull Map.Entry<String, CompoundBinaryTag> readNamed(@NonNull DataInput input) throws IOException {
        BinaryTagType<BinaryTag> type = BinaryTagType.of(input.readByte());
        BinaryTagReaderImpl.requireCompound(type);
        String name = input.readUTF();
        return new AbstractMap.SimpleImmutableEntry<String, CompoundBinaryTag>(name, BinaryTagTypes.COMPOUND.read(input));
    }

    private static void requireCompound(BinaryTagType<? extends BinaryTag> type) throws IOException {
        if (type != BinaryTagTypes.COMPOUND) {
            throw new IOException(String.format("Expected root tag to be a %s, was %s", BinaryTagTypes.COMPOUND, type));
        }
    }
}

