/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.nbt;

import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.ByteArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.ByteBinaryTag;
import com.sk89q.worldedit.util.nbt.DoubleBinaryTag;
import com.sk89q.worldedit.util.nbt.FloatBinaryTag;
import com.sk89q.worldedit.util.nbt.IntArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.LongArrayBinaryTag;
import com.sk89q.worldedit.util.nbt.LongBinaryTag;
import com.sk89q.worldedit.util.nbt.ShortBinaryTag;
import com.sk89q.worldedit.util.nbt.StringBinaryTag;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CompoundTagSetter<R> {
    public @NonNull R put(@NonNull String var1, @NonNull BinaryTag var2);

    public @NonNull R put(@NonNull Map<String, ? extends BinaryTag> var1);

    default public @NonNull R remove(@NonNull String key) {
        return this.remove(key, null);
    }

    public @NonNull R remove(@NonNull String var1, @Nullable Consumer<? super BinaryTag> var2);

    default public @NonNull R putBoolean(@NonNull String key, boolean value) {
        return this.put(key, value ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    }

    default public @NonNull R putByte(@NonNull String key, byte value) {
        return this.put(key, ByteBinaryTag.of(value));
    }

    default public @NonNull R putShort(@NonNull String key, short value) {
        return this.put(key, ShortBinaryTag.of(value));
    }

    default public @NonNull R putInt(@NonNull String key, int value) {
        return this.put(key, IntBinaryTag.of(value));
    }

    default public @NonNull R putLong(@NonNull String key, long value) {
        return this.put(key, LongBinaryTag.of(value));
    }

    default public @NonNull R putFloat(@NonNull String key, float value) {
        return this.put(key, FloatBinaryTag.of(value));
    }

    default public @NonNull R putDouble(@NonNull String key, double value) {
        return this.put(key, DoubleBinaryTag.of(value));
    }

    default public @NonNull R putByteArray(@NonNull String key, byte @NonNull [] value) {
        return this.put(key, ByteArrayBinaryTag.of(value));
    }

    default public @NonNull R putString(@NonNull String key, @NonNull String value) {
        return this.put(key, StringBinaryTag.of(value));
    }

    default public @NonNull R putIntArray(@NonNull String key, int @NonNull [] value) {
        return this.put(key, IntArrayBinaryTag.of(value));
    }

    default public @NonNull R putLongArray(@NonNull String key, long @NonNull [] value) {
        return this.put(key, LongArrayBinaryTag.of(value));
    }
}

