/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.nbt;

import com.sk89q.worldedit.util.nbt.AbstractBinaryTag;
import com.sk89q.worldedit.util.nbt.LongBinaryTag;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LongBinaryTagImpl
extends AbstractBinaryTag
implements LongBinaryTag {
    private final long value;

    LongBinaryTagImpl(long value) {
        this.value = value;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFFL);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFFL);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LongBinaryTagImpl that = (LongBinaryTagImpl)other;
        return this.value == that.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("value", this.value));
    }
}

