/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.TagStringIO;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class BaseBlock
implements BlockStateHolder<BaseBlock>,
TileEntityBlock {
    private final BlockState blockState;
    @Nullable
    private final LazyReference<CompoundBinaryTag> nbtData;

    protected BaseBlock(BlockState blockState) {
        this.blockState = blockState;
        this.nbtData = null;
    }

    @Deprecated
    protected BaseBlock(BlockState state, CompoundTag nbtData) {
        this(state, LazyReference.from(((CompoundTag)Preconditions.checkNotNull((Object)nbtData))::asBinaryTag));
    }

    protected BaseBlock(BlockState state, LazyReference<CompoundBinaryTag> nbtData) {
        Preconditions.checkNotNull(nbtData);
        this.blockState = state;
        this.nbtData = nbtData;
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return this.blockState.getStates();
    }

    @Override
    public BlockType getBlockType() {
        return this.blockState.getBlockType();
    }

    @Override
    public <V> BaseBlock with(Property<V> property, V value) {
        return ((BlockState)this.blockState.with((Property)property, (Object)value)).toBaseBlock(this.getNbtReference());
    }

    @Override
    public <V> V getState(Property<V> property) {
        return this.blockState.getState(property);
    }

    @Override
    public String getNbtId() {
        LazyReference<CompoundBinaryTag> nbtData = this.nbtData;
        if (nbtData == null) {
            return "";
        }
        return nbtData.getValue().getString("id");
    }

    @Override
    @Nullable
    public LazyReference<CompoundBinaryTag> getNbtReference() {
        return this.nbtData;
    }

    @Override
    public void setNbtReference(@Nullable LazyReference<CompoundBinaryTag> nbtData) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseBlock)) {
            if (this.nbtData == null && o instanceof BlockStateHolder) {
                return Objects.equals(this.toImmutableState(), ((BlockStateHolder)o).toImmutableState());
            }
            return false;
        }
        BaseBlock otherBlock = (BaseBlock)o;
        return this.blockState.equalsFuzzy(otherBlock.blockState) && Objects.equals(this.getNbt(), otherBlock.getNbt());
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        return this.blockState.equalsFuzzy(o);
    }

    @Override
    public BlockState toImmutableState() {
        return this.blockState;
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this;
    }

    @Override
    public BaseBlock toBaseBlock(LazyReference<CompoundBinaryTag> compoundTag) {
        if (compoundTag == null) {
            return this.blockState.toBaseBlock();
        }
        if (compoundTag == this.nbtData) {
            return this;
        }
        return new BaseBlock(this.blockState, compoundTag);
    }

    public int hashCode() {
        int ret = this.toImmutableState().hashCode() << 3;
        CompoundBinaryTag nbtData = this.getNbt();
        if (nbtData != null) {
            ret += nbtData.hashCode();
        }
        return ret;
    }

    public String toString() {
        String nbtString = "";
        CompoundBinaryTag nbtData = this.getNbt();
        if (nbtData != null) {
            try {
                nbtString = TagStringIO.get().asString(nbtData);
            }
            catch (IOException e) {
                WorldEdit.logger.error("Failed to serialize NBT of Block", (Throwable)e);
            }
        }
        return this.blockState.getAsString() + nbtString;
    }
}

