/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.NbtUtils;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AnvilChunk
implements Chunk {
    private final CompoundBinaryTag rootTag;
    private final byte[][] blocks;
    private final byte[][] blocksAdd;
    private final byte[][] data;
    private final int rootX;
    private final int rootZ;
    private Map<BlockVector3, CompoundBinaryTag> tileEntities;

    public AnvilChunk(CompoundTag tag) throws DataException {
        this(tag.asBinaryTag());
    }

    public AnvilChunk(CompoundBinaryTag tag) throws DataException {
        this.rootTag = tag;
        this.rootX = NbtUtils.getChildTag(this.rootTag, "xPos", BinaryTagTypes.INT).value();
        this.rootZ = NbtUtils.getChildTag(this.rootTag, "zPos", BinaryTagTypes.INT).value();
        this.blocks = new byte[16][4096];
        this.blocksAdd = new byte[16][2048];
        this.data = new byte[16][2048];
        ListBinaryTag sections = NbtUtils.getChildTag(this.rootTag, "Sections", BinaryTagTypes.LIST);
        for (BinaryTag rawSectionTag : sections) {
            byte y;
            CompoundBinaryTag sectionTag;
            if (!(rawSectionTag instanceof CompoundBinaryTag) || (sectionTag = (CompoundBinaryTag)rawSectionTag).get("Y") == null || (y = NbtUtils.getChildTag(sectionTag, "Y", BinaryTagTypes.BYTE).value()) < 0 || y >= 16) continue;
            this.blocks[y] = NbtUtils.getChildTag(sectionTag, "Blocks", BinaryTagTypes.BYTE_ARRAY).value();
            this.data[y] = NbtUtils.getChildTag(sectionTag, "Data", BinaryTagTypes.BYTE_ARRAY).value();
            if (sectionTag.get("Add") == null) continue;
            this.blocksAdd[y] = NbtUtils.getChildTag(sectionTag, "Add", BinaryTagTypes.BYTE_ARRAY).value();
        }
        int sectionsize = 4096;
        for (byte[] block : this.blocks) {
            if (block.length == sectionsize) continue;
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + sectionsize + " bytes; found " + block.length);
        }
        for (byte[] aData : this.data) {
            if (aData.length == sectionsize / 2) continue;
            throw new InvalidFormatException("Chunk block data byte array expected to be " + sectionsize + " bytes; found " + aData.length);
        }
    }

    private int getBlockID(BlockVector3 position) throws DataException {
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int section = y >> 4;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + position);
        }
        int yindex = y & 0xF;
        int index = x + (z * 16 + yindex * 16 * 16);
        try {
            int addId = 0;
            addId = index % 2 == 0 ? (this.blocksAdd[section][index >> 1] & 0xF) << 8 : (this.blocksAdd[section][index >> 1] & 0xF0) << 4;
            return (this.blocks[section][index] & 0xFF) + addId;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
    }

    private int getBlockData(BlockVector3 position) throws DataException {
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int section = y >> 4;
        int yIndex = y & 0xF;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + position);
        }
        int index = x + (z * 16 + yIndex * 16 * 16);
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            if (!shift) {
                return (this.data[section][index] & 0xF0) >> 4;
            }
            return this.data[section][index] & 0xF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataException("Chunk does not contain position " + position);
        }
    }

    private void populateTileEntities() throws DataException {
        ListBinaryTag tags = NbtUtils.getChildTag(this.rootTag, "TileEntities", BinaryTagTypes.LIST);
        this.tileEntities = new HashMap<BlockVector3, CompoundBinaryTag>();
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            CompoundBinaryTag.Builder values = CompoundBinaryTag.builder();
            for (String key : t.keySet()) {
                BinaryTag value = t.get(key);
                switch (key) {
                    case "x": {
                        if (!(value instanceof IntBinaryTag)) break;
                        x = ((IntBinaryTag)value).value();
                        break;
                    }
                    case "y": {
                        if (!(value instanceof IntBinaryTag)) break;
                        y = ((IntBinaryTag)value).value();
                        break;
                    }
                    case "z": {
                        if (!(value instanceof IntBinaryTag)) break;
                        z = ((IntBinaryTag)value).value();
                        break;
                    }
                }
                values.put(key, value);
            }
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, values.build());
        }
    }

    @Nullable
    private CompoundBinaryTag getBlockTileEntity(BlockVector3 position) throws DataException {
        CompoundBinaryTag values;
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        if ((values = this.tileEntities.get(position)) == null) {
            return null;
        }
        return values;
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int id = this.getBlockID(position);
        int data = this.getBlockData(position);
        BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(id, data);
        if (state == null) {
            WorldEdit.logger.warn("Unknown legacy block " + id + ":" + data + " found when loading legacy anvil chunk.");
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        CompoundBinaryTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

