/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.util.nbt.NbtUtils;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AnvilChunk13
implements Chunk {
    private final CompoundBinaryTag rootTag;
    private final BlockState[][] blocks;
    private final int rootX;
    private final int rootZ;
    private Map<BlockVector3, CompoundBinaryTag> tileEntities;

    @Deprecated
    public AnvilChunk13(CompoundTag tag) throws DataException {
        this(tag.asBinaryTag());
    }

    public AnvilChunk13(CompoundBinaryTag tag) throws DataException {
        this.rootTag = tag;
        this.rootX = NbtUtils.getChildTag(this.rootTag, "xPos", BinaryTagTypes.INT).value();
        this.rootZ = NbtUtils.getChildTag(this.rootTag, "zPos", BinaryTagTypes.INT).value();
        this.blocks = new BlockState[16][];
        ListBinaryTag sections = NbtUtils.getChildTag(this.rootTag, "Sections", BinaryTagTypes.LIST);
        for (BinaryTag rawSectionTag : sections) {
            ListBinaryTag paletteEntries;
            int paletteSize;
            byte y;
            CompoundBinaryTag sectionTag;
            if (!(rawSectionTag instanceof CompoundBinaryTag) || (sectionTag = (CompoundBinaryTag)rawSectionTag).get("Y") == null || (y = NbtUtils.getChildTag(sectionTag, "Y", BinaryTagTypes.BYTE).value()) < 0 || y >= 16 || (paletteSize = (paletteEntries = sectionTag.getList("Palette", BinaryTagTypes.COMPOUND)).size()) == 0) continue;
            BlockState[] palette = new BlockState[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                CompoundBinaryTag paletteEntry = (CompoundBinaryTag)paletteEntries.get(paletteEntryId);
                BlockType type = BlockTypes.get(paletteEntry.getString("Name"));
                if (type == null) {
                    throw new InvalidFormatException("Invalid block type: " + paletteEntry.getString("Name"));
                }
                BlockState blockState = type.getDefaultState();
                if (paletteEntry.get("Properties") != null) {
                    CompoundBinaryTag properties = NbtUtils.getChildTag(paletteEntry, "Properties", BinaryTagTypes.COMPOUND);
                    for (Property<?> property : blockState.getStates().keySet()) {
                        if (properties.get(property.getName()) == null) continue;
                        String value = properties.getString(property.getName());
                        try {
                            blockState = this.getBlockStateWith(blockState, property, value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidFormatException("Invalid block state for " + blockState.getBlockType().getId() + ", " + property.getName() + ": " + value);
                        }
                    }
                }
                palette[paletteEntryId] = blockState;
            }
            long[] blockStatesSerialized = NbtUtils.getChildTag(sectionTag, "BlockStates", BinaryTagTypes.LONG_ARRAY).value();
            BlockState[] chunkSectionBlocks = new BlockState[4096];
            this.blocks[y] = chunkSectionBlocks;
            this.readBlockStates(palette, blockStatesSerialized, chunkSectionBlocks);
        }
    }

    protected void readBlockStates(BlockState[] palette, long[] blockStatesSerialized, BlockState[] chunkSectionBlocks) throws InvalidFormatException {
        int paletteBits = 4;
        while (1 << paletteBits < palette.length) {
            ++paletteBits;
        }
        int paletteMask = (1 << paletteBits) - 1;
        long currentSerializedValue = 0L;
        int nextSerializedItem = 0;
        int remainingBits = 0;
        for (int blockPos = 0; blockPos < chunkSectionBlocks.length; ++blockPos) {
            int localBlockId;
            if (remainingBits < paletteBits) {
                int bitsNextLong = paletteBits - remainingBits;
                localBlockId = (int)currentSerializedValue;
                if (nextSerializedItem >= blockStatesSerialized.length) {
                    throw new InvalidFormatException("Too short block state table");
                }
                currentSerializedValue = blockStatesSerialized[nextSerializedItem++];
                localBlockId = (int)((long)localBlockId | (currentSerializedValue & (long)((1 << bitsNextLong) - 1)) << remainingBits);
                currentSerializedValue >>>= bitsNextLong;
                remainingBits = 64 - bitsNextLong;
            } else {
                localBlockId = (int)(currentSerializedValue & (long)paletteMask);
                currentSerializedValue >>>= paletteBits;
                remainingBits -= paletteBits;
            }
            if (localBlockId >= palette.length) {
                throw new InvalidFormatException("Invalid block state table entry: " + localBlockId);
            }
            chunkSectionBlocks[blockPos] = palette[localBlockId];
        }
    }

    private <T> BlockState getBlockStateWith(BlockState source, Property<T> property, String value) {
        return source.with(property, property.getValueFor(value));
    }

    private void populateTileEntities() throws DataException {
        this.tileEntities = new HashMap<BlockVector3, CompoundBinaryTag>();
        if (this.rootTag.get("TileEntities") == null) {
            return;
        }
        ListBinaryTag tags = NbtUtils.getChildTag(this.rootTag, "TileEntities", BinaryTagTypes.LIST);
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            int x = ((IntBinaryTag)t.get("x")).value();
            int y = ((IntBinaryTag)t.get("y")).value();
            int z = ((IntBinaryTag)t.get("z")).value();
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, t);
        }
    }

    @Nullable
    private CompoundBinaryTag getBlockTileEntity(BlockVector3 position) throws DataException {
        CompoundBinaryTag values;
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        if ((values = this.tileEntities.get(position)) == null) {
            return null;
        }
        return values;
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int x = position.getX() - this.rootX * 16;
        int y = position.getY();
        int z = position.getZ() - this.rootZ * 16;
        int section = y >> 4;
        int yIndex = y & 0xF;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + position);
        }
        BlockState[] sectionBlocks = this.blocks[section];
        BlockState state = sectionBlocks != null ? sectionBlocks[yIndex << 8 | z << 4 | x] : BlockTypes.AIR.getDefaultState();
        CompoundBinaryTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }
}

