/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mohistmc.util.i18n.i18n;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionReader;
import net.minecraft.tags.TagRegistry;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeTagHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ResourceLocation, ITagCollection<?>> customTagTypes = Collections.emptyMap();
    private static Set<ResourceLocation> customTagTypeNames = Collections.emptySet();
    private static boolean tagTypesSet = false;

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> TagRegistry<T> getTagRegistry(IForgeRegistry<T> registry) {
        return TagRegistryManager.get((ResourceLocation)registry.getRegistryName());
    }

    private static void validateRegistrySupportsTags(IForgeRegistry<?> registry) {
        if (!(ForgeTagHandler.getTagRegistry(registry) != null || registry instanceof ForgeRegistry && ((ForgeRegistry)registry).getTagFolder() != null)) {
            throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
        }
    }

    public static <T extends IForgeRegistryEntry<T>> ITag.INamedTag<T> makeWrapperTag(IForgeRegistry<T> registry, ResourceLocation name) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            TagRegistry<T> tagRegistry = ForgeTagHandler.getTagRegistry(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.func_232937_a_(name.toString());
        }
        return TagRegistry.createDelayedTag((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registry, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            TagRegistry<T> tagRegistry = ForgeTagHandler.getTagRegistry(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.createOptional(name, defaults);
        }
        return TagRegistry.createDelayedOptional((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name, defaults);
    }

    public static <T extends IForgeRegistryEntry<T>> ITag.INamedTag<T> makeWrapperTag(ResourceLocation registryName, ResourceLocation name) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.makeWrapperTag(registry, name);
        }
        return TagRegistry.createDelayedTag((ResourceLocation)registryName, (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registryName, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name, @Nullable Set<Supplier<T>> defaults) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.createOptionalTag(registry, name, defaults);
        }
        return TagRegistry.createDelayedOptional((ResourceLocation)registryName, (ResourceLocation)name, defaults);
    }

    public static Set<ResourceLocation> getCustomTagTypeNames() {
        return customTagTypeNames;
    }

    public static Map<ResourceLocation, ITagCollection<?>> getCustomTagTypes() {
        return customTagTypes;
    }

    public static void setCustomTagTypes(Set<ResourceLocation> customTagTypes) {
        if (tagTypesSet) {
            throw new RuntimeException("Custom tag types have already been set, this method should only be called by forge, and after registries are initialized");
        }
        tagTypesSet = true;
        customTagTypeNames = ImmutableSet.copyOf(customTagTypes);
        TagRegistry.performDelayedAdd();
    }

    public static Map<ResourceLocation, TagCollectionReader<?>> createCustomTagTypeReaders() {
        LOGGER.debug(i18n.get((String)"forgetaghandler.1"));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null || registry.getTagFolder() == null) continue;
            builder.put((Object)registryName, (Object)new TagCollectionReader(rl -> Optional.ofNullable(registry.getValue((ResourceLocation)rl)), "tags/" + registry.getTagFolder(), registryName.func_110623_a()));
        }
        return builder.build();
    }

    public static void resetCachedTagCollections(boolean makeEmpty, boolean withOptional) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            TagRegistry tagRegistry = TagRegistryManager.get((ResourceLocation)registryName);
            if (tagRegistry == null) continue;
            if (makeEmpty) {
                if (withOptional) {
                    builder.put((Object)registryName, (Object)tagRegistry.reinjectOptionalTags(ITagCollection.func_242202_a(Collections.emptyMap())));
                    continue;
                }
                builder.put((Object)registryName, (Object)ITagCollection.func_242202_a(Collections.emptyMap()));
                continue;
            }
            builder.put((Object)registryName, (Object)ITagCollection.func_242202_a(tagRegistry.func_241288_c_().stream().distinct().collect(Collectors.toMap(ITag.INamedTag::func_230234_a_, namedTag -> namedTag))));
        }
        customTagTypes = builder.build();
    }

    public static ITagCollectionSupplier populateTagCollectionManager(ITagCollection<Block> blockTags, ITagCollection<Item> itemTags, ITagCollection<Fluid> fluidTags, ITagCollection<EntityType<?>> entityTypeTags) {
        ForgeTagHandler.resetCachedTagCollections(false, false);
        if (!customTagTypes.isEmpty()) {
            LOGGER.debug(i18n.get((String)"forgetaghandler.2", (Object[])new Object[]{customTagTypes.size()}));
        }
        return ITagCollectionSupplier.func_242209_a(blockTags, itemTags, fluidTags, entityTypeTags);
    }

    public static void updateCustomTagTypes(List<TagCollectionReaderInfo> tagCollectionReaders) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TagCollectionReaderInfo info : tagCollectionReaders) {
            builder.put((Object)info.tagType, (Object)info.reader.func_242226_a(info.tagBuilders));
        }
        customTagTypes = builder.build();
    }

    public static void updateCustomTagTypes(FMLPlayMessages.SyncCustomTagTypes packet) {
        customTagTypes = packet.getCustomTagTypes();
        ForgeTagHandler.reinjectOptionalTagsCustomTypes();
    }

    public static CompletableFuture<List<TagCollectionReaderInfo>> getCustomTagTypeReloadResults(IResourceManager resourceManager, Executor backgroundExecutor, Map<ResourceLocation, TagCollectionReader<?>> readers) {
        CompletionStage<List<TagCollectionReaderInfo>> customResults = CompletableFuture.completedFuture(new ArrayList());
        for (Map.Entry<ResourceLocation, TagCollectionReader<?>> entry : readers.entrySet()) {
            customResults = customResults.thenCombine((CompletionStage)entry.getValue().func_242224_a(resourceManager, backgroundExecutor), (results, result) -> {
                results.add(new TagCollectionReaderInfo((ResourceLocation)entry.getKey(), (TagCollectionReader<?>)((TagCollectionReader)entry.getValue()), (Map<ResourceLocation, ITag.Builder>)result));
                return results;
            });
        }
        return customResults;
    }

    public static void reinjectOptionalTagsCustomTypes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ITagCollection<?>> entry : customTagTypes.entrySet()) {
            ResourceLocation registry = entry.getKey();
            TagRegistry tagRegistry = TagRegistryManager.get((ResourceLocation)registry);
            ITagCollection tagCollection = entry.getValue();
            builder.put((Object)registry, tagRegistry == null ? tagCollection : tagRegistry.reinjectOptionalTags(tagCollection));
        }
        customTagTypes = builder.build();
    }

    public static ITagCollectionSupplier withNoCustom(ITagCollectionSupplier tagCollectionSupplier) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            TagRegistry tagRegistry = TagRegistryManager.get((ResourceLocation)registryName);
            if (tagRegistry == null) continue;
            builder.put((Object)registryName, (Object)ITagCollection.func_242202_a(Collections.emptyMap()));
        }
        return ForgeTagHandler.withSpecificCustom(tagCollectionSupplier, builder.build());
    }

    public static ITagCollectionSupplier withSpecificCustom(final ITagCollectionSupplier tagCollectionSupplier, final Map<ResourceLocation, ITagCollection<?>> customTagTypes) {
        return new ITagCollectionSupplier(){

            public ITagCollection<Block> func_241835_a() {
                return tagCollectionSupplier.func_241835_a();
            }

            public ITagCollection<Item> func_241836_b() {
                return tagCollectionSupplier.func_241836_b();
            }

            public ITagCollection<Fluid> func_241837_c() {
                return tagCollectionSupplier.func_241837_c();
            }

            public ITagCollection<EntityType<?>> func_241838_d() {
                return tagCollectionSupplier.func_241838_d();
            }

            public Map<ResourceLocation, ITagCollection<?>> getCustomTagTypes() {
                return customTagTypes;
            }
        };
    }

    public static class TagCollectionReaderInfo {
        private final ResourceLocation tagType;
        private final TagCollectionReader<?> reader;
        private final Map<ResourceLocation, ITag.Builder> tagBuilders;

        private TagCollectionReaderInfo(ResourceLocation tagType, TagCollectionReader<?> reader, Map<ResourceLocation, ITag.Builder> tagBuilders) {
            this.tagType = tagType;
            this.reader = reader;
            this.tagBuilders = tagBuilders;
        }
    }
}

