/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends JsonReloadListener {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON_INSTANCE = LootSerializers.func_237387_b_().create();
    private Map<ResourceLocation, IGlobalLootModifier> registeredLootModifiers = ImmutableMap.of();
    private static final String folder = "loot_modifiers";

    public LootModifierManager() {
        super(GSON_INSTANCE, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Map<ResourceLocation, JsonElement> resourceList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ImmutableMap immutablemap;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
        ResourceLocation resourcelocation = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
        try {
            for (IResource iresource : resourceManagerIn.func_199004_b(resourcelocation)) {
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonObject jsonobject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                        boolean replace = jsonobject.get("replace").getAsBoolean();
                        if (replace) {
                            finalLocations.clear();
                        }
                        JsonArray entryList = jsonobject.get("entries").getAsJsonArray();
                        for (JsonElement entry : entryList) {
                            String loc = entry.getAsString();
                            ResourceLocation res = new ResourceLocation(loc);
                            if (finalLocations.contains(res)) {
                                finalLocations.remove(res);
                            }
                            finalLocations.add(res);
                        }
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                catch (IOException | RuntimeException ioexception) {
                    LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)resourcelocation, (Object)iresource.func_199026_d(), (Object)ioexception);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
            }
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't read global loot modifier list from {}", (Object)resourcelocation, (Object)ioexception1);
        }
        finalLocations.forEach(location -> {
            try {
                IGlobalLootModifier modifier = this.deserializeModifier((ResourceLocation)location, (JsonElement)resourceList.get(location));
                if (modifier != null) {
                    builder.put(location, (Object)modifier);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse loot modifier {}", location, (Object)exception);
            }
        });
        this.registeredLootModifiers = immutablemap = builder.build();
    }

    private IGlobalLootModifier deserializeModifier(ResourceLocation location, JsonElement element) {
        if (!element.isJsonObject()) {
            return null;
        }
        JsonObject object = element.getAsJsonObject();
        ILootCondition[] lootConditions = (ILootCondition[])GSON_INSTANCE.fromJson(object.get("conditions"), ILootCondition[].class);
        ResourceLocation serializer = location;
        if (object.has("type")) {
            serializer = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
        }
        return ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.getValue(serializer).read(location, object, lootConditions);
    }

    public static GlobalLootModifierSerializer<?> getSerializerForName(ResourceLocation resourcelocation) {
        return ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.getValue(resourcelocation);
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.registeredLootModifiers.values();
    }
}

