/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import com.mohistmc.util.i18n.i18n;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.FMLStatusPing;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.LanguageHook;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkFilters;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final FolderName SERVERCONFIG = new FolderName("serverconfig");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.func_240776_a_(SERVERCONFIG);
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        return serverConfig;
    }

    public static boolean handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        currentServer.func_147134_at().setForgeData(new FMLStatusPing());
        LogicalSidedProvider.setServer(() -> server);
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerAboutToStartEvent(server));
    }

    public static boolean handleServerStarting(MinecraftServer server) {
        DistExecutor.runWhenOn(Dist.DEDICATED_SERVER, () -> () -> LanguageHook.loadLanguagesOnServer(server));
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        if (!server.func_71262_S()) {
            GameData.revertToFrozen();
        }
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(CHandshakePacket packet, NetworkManager manager) {
        if (!allowLogins.get()) {
            StringTextComponent text = new StringTextComponent(i18n.get((String)"serverlifecyclehooks.1"));
            LOGGER.info(SERVERHOOKS, i18n.get((String)"serverlifecyclehooks.2", (Object[])new Object[]{text.func_150261_e()}));
            manager.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)text));
            manager.func_150718_a((ITextComponent)text);
            return false;
        }
        if (packet.func_149594_c() == ProtocolType.LOGIN) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 2) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, i18n.get((String)"serverlifecyclehooks.3", (Object[])new Object[]{versionNumber, 2}));
                return false;
            }
            if (connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, i18n.get((String)"serverlifecyclehooks.4"));
                return false;
            }
        }
        if (packet.func_149594_c() == ProtocolType.STATUS) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        NetworkFilters.injectIfNecessary(manager);
        return true;
    }

    private static void rejectConnection(NetworkManager manager, ConnectionType type, String message) {
        manager.func_150723_a(ProtocolType.LOGIN);
        LOGGER.info(SERVERHOOKS, i18n.get((String)"serverlifecyclehooks.5", (Object[])new Object[]{type, message}));
        StringTextComponent text = new StringTextComponent(message);
        manager.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)text));
        manager.func_150718_a((ITextComponent)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    @Deprecated
    public static ResourcePackLoader.IPackInfoFinder buildPackFinder(Map<ModFile, ? extends ModFileResourcePack> modResourcePacks, BiConsumer<? super ModFileResourcePack, ResourcePackInfo> packSetter) {
        return (packList, factory) -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packSetter, packList, factory);
    }

    private static void serverPackFinder(Map<ModFile, ? extends ModFileResourcePack> modResourcePacks, BiConsumer<? super ModFileResourcePack, ResourcePackInfo> packSetter, Consumer<ResourcePackInfo> consumer, ResourcePackInfo.IFactory factory) {
        for (Map.Entry<ModFile, ? extends ModFileResourcePack> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)name, (boolean)false, e::getValue, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.BOTTOM, (IPackNameDecorator)IPackNameDecorator.field_232625_a_);
            if (packInfo == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", e.getKey()));
                continue;
            }
            packSetter.accept(e.getValue(), packInfo);
            LOGGER.debug(Logging.CORE, i18n.get((String)"serverlifecyclehooks.6", (Object[])new Object[]{name, e.getKey().getFilePath()}));
            consumer.accept(packInfo);
        }
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

