/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private WeakReference<net.minecraft.world.chunk.Chunk> weakChunk;
    private final net.minecraft.world.World worldServer;
    private final int x;
    private final int z;
    private static final PalettedContainer<net.minecraft.block.BlockState> emptyBlockIDs = new ChunkSection(0).func_186049_g();
    private static final byte[] emptyLight = new byte[2048];

    public CraftChunk(net.minecraft.world.chunk.Chunk chunk) {
        this.weakChunk = new WeakReference<net.minecraft.world.chunk.Chunk>(chunk);
        this.worldServer = this.getHandle().field_76637_e;
        this.x = this.getHandle().func_76632_l().field_77276_a;
        this.z = this.getHandle().func_76632_l().field_77275_b;
    }

    @Override
    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public net.minecraft.world.chunk.Chunk getHandle() {
        net.minecraft.world.chunk.Chunk c = (net.minecraft.world.chunk.Chunk)this.weakChunk.get();
        if (c == null) {
            c = this.worldServer.func_212866_a_(this.x, this.z);
            this.weakChunk = new WeakReference<net.minecraft.world.chunk.Chunk>(c);
        }
        return c;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        CraftChunk.validateChunkCoordinates(x, y, z);
        return new CraftBlock((IWorld)this.worldServer, new BlockPos(this.x << 4 | x, y, this.z << 4 | z));
    }

    @Override
    public org.bukkit.entity.Entity[] getEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int count = 0;
        int index = 0;
        net.minecraft.world.chunk.Chunk chunk = this.getHandle();
        for (int i = 0; i < 16; ++i) {
            count += chunk.field_76645_j[i].size();
        }
        org.bukkit.entity.Entity[] entities = new org.bukkit.entity.Entity[count];
        for (int i = 0; i < 16; ++i) {
            for (Object obj : chunk.field_76645_j[i].toArray()) {
                if (!(obj instanceof Entity)) continue;
                entities[index++] = ((Entity)obj).getBukkitEntity();
            }
        }
        return entities;
    }

    @Override
    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        net.minecraft.world.chunk.Chunk chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.field_150816_i.size()];
        for (Object obj : chunk.field_150816_i.keySet().toArray()) {
            if (!(obj instanceof BlockPos)) continue;
            BlockPos position = (BlockPos)obj;
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.func_177958_n(), position.func_177956_o(), position.func_177952_p()).getState();
        }
        return entities;
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    @Override
    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    @Override
    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    @Override
    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    @Override
    public boolean isSlimeChunk() {
        return SharedSeedRandom.func_205190_a((int)this.getX(), (int)this.getZ(), (long)this.getWorld().getSeed(), (long)987234911L).nextInt(10) == 0;
    }

    @Override
    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    @Override
    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    @Override
    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    @Override
    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    @Override
    public long getInhabitedTime() {
        return this.getHandle().func_177416_w();
    }

    @Override
    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle().func_177415_c(ticks);
    }

    @Override
    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (ChunkSection section : this.getHandle().func_76587_i()) {
            if (section == null || !section.func_186049_g().func_235963_a_((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        net.minecraft.world.chunk.Chunk chunk = this.getHandle();
        ChunkSection[] cs = chunk.func_76587_i();
        PalettedContainer[] sectionBlockIDs = new PalettedContainer[cs.length];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == null) {
                sectionBlockIDs[i] = emptyBlockIDs;
                sectionSkyLights[i] = emptyLight;
                sectionEmitLights[i] = emptyLight;
                sectionEmpty[i] = true;
                continue;
            }
            CompoundNBT data = new CompoundNBT();
            cs[i].func_186049_g().func_196963_b(data, "Palette", "BlockStates");
            PalettedContainer blockids = new PalettedContainer(ChunkSection.field_205512_a, net.minecraft.block.Block.field_176229_d, NBTUtil::func_190008_d, NBTUtil::func_190009_a, (Object)Blocks.field_150350_a.func_176223_P());
            blockids.func_222642_a(data.func_150295_c("Palette", 10), data.func_197645_o("BlockStates"));
            sectionBlockIDs[i] = blockids;
            WorldLightManager lightengine = chunk.field_76637_e.func_72863_F().func_212863_j_();
            NibbleArray skyLightArray = lightengine.func_215569_a(LightType.SKY).func_215612_a(SectionPos.func_218154_a((int)this.x, (int)i, (int)this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i] = emptyLight;
            } else {
                sectionSkyLights[i] = new byte[2048];
                System.arraycopy(skyLightArray.func_177481_a(), 0, sectionSkyLights[i], 0, 2048);
            }
            NibbleArray emitLightArray = lightengine.func_215569_a(LightType.BLOCK).func_215612_a(SectionPos.func_218154_a((int)this.x, (int)i, (int)this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i] = emptyLight;
                continue;
            }
            sectionEmitLights[i] = new byte[2048];
            System.arraycopy(emitLightArray.func_177481_a(), 0, sectionEmitLights[i], 0, 2048);
        }
        Heightmap hmap = null;
        if (includeMaxBlockY) {
            hmap = new Heightmap(null, Heightmap.Type.MOTION_BLOCKING);
            hmap.func_202268_a(((Heightmap)chunk.field_76634_f.get(Heightmap.Type.MOTION_BLOCKING)).func_202269_a());
        }
        BiomeContainer biome = null;
        if (includeBiome || includeBiomeTempRain) {
            biome = chunk.func_225549_i_();
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome);
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        BiomeContainer biome = null;
        if (includeBiome || includeBiomeTempRain) {
            BiomeProvider wcm = world.getHandle().func_72863_F().func_201711_g().func_202090_b();
            biome = new BiomeContainer((IObjectIntIterable)world.getHandle().func_241828_r().func_243612_b(Registry.field_239720_u_), new ChunkPos(x, z), wcm);
        }
        int hSection = world.getMaxHeight() >> 4;
        PalettedContainer[] blockIDs = new PalettedContainer[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        for (int i = 0; i < hSection; ++i) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = emptyLight;
            emitLight[i] = emptyLight;
            empty[i] = true;
        }
        return new CraftChunkSnapshot(x, z, world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new Heightmap(null, Heightmap.Type.MOTION_BLOCKING), biome);
    }

    static void validateChunkCoordinates(int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((0 <= y && y <= 255 ? 1 : 0) != 0, (String)"y out of range (expected 0-255, got %s)", (int)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }

    static {
        Arrays.fill(emptyLight, (byte)-1);
    }
}

