/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final net.minecraft.loot.LootTable handle;
    private final NamespacedKey key;

    public CraftLootTable(NamespacedKey key, net.minecraft.loot.LootTable handle) {
        this.handle = handle;
        this.key = key;
    }

    public net.minecraft.loot.LootTable getHandle() {
        return this.handle;
    }

    @Override
    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        net.minecraft.loot.LootContext nmsContext = this.convertContext(context);
        List nmsItems = this.handle.func_216113_a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (net.minecraft.item.ItemStack item : nmsItems) {
            if (item.func_190926_b()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    @Override
    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        net.minecraft.loot.LootContext nmsContext = this.convertContext(context);
        CraftInventory craftInventory = (CraftInventory)inventory;
        IInventory handle = craftInventory.getInventory();
        this.getHandle().func_216118_a(handle, nmsContext);
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    private net.minecraft.loot.LootContext convertContext(LootContext context) {
        Location loc = context.getLocation();
        ServerWorld handle = ((CraftWorld)loc.getWorld()).getHandle();
        LootContext.Builder builder = new LootContext.Builder(handle);
        this.setMaybe(builder, LootParameters.field_237457_g_, new Vector3d(loc.getX(), loc.getY(), loc.getZ()));
        if (this.getHandle() != net.minecraft.loot.LootTable.field_186464_a) {
            if (context.getLootedEntity() != null) {
                Entity nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, LootParameters.field_216281_a, nmsLootedEntity);
                this.setMaybe(builder, LootParameters.field_216283_c, DamageSource.field_76377_j);
                this.setMaybe(builder, LootParameters.POSITION, new BlockPos(nmsLootedEntity));
            }
            if (context.getKiller() != null) {
                PlayerEntity nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, LootParameters.field_216284_d, nmsKiller);
                this.setMaybe(builder, LootParameters.field_216283_c, DamageSource.func_76365_a((PlayerEntity)nmsKiller));
                this.setMaybe(builder, LootParameters.field_216282_b, nmsKiller);
            }
            if (context.getLootingModifier() != -1) {
                this.setMaybe(builder, LootParameters.LOOTING_MOD, context.getLootingModifier());
            }
        }
        LootParameterSet.Builder nmsBuilder = new LootParameterSet.Builder();
        for (LootParameter param : this.getHandle().func_216122_a().func_216276_b()) {
            nmsBuilder.func_216269_a(param);
        }
        for (LootParameter param : this.getHandle().func_216122_a().func_216276_b()) {
            if (this.getHandle().func_216122_a().func_216276_b().contains(param)) continue;
            nmsBuilder.func_216271_b(param);
        }
        nmsBuilder.func_216271_b(LootParameters.LOOTING_MOD);
        return builder.func_216022_a(nmsBuilder.func_216270_a());
    }

    private <T> void setMaybe(LootContext.Builder builder, LootParameter<T> param, T value) {
        if (this.getHandle().func_216122_a().func_216277_a().contains(param) || this.getHandle().func_216122_a().func_216276_b().contains(param)) {
            builder.func_216015_a(param, value);
        }
    }

    public static LootContext convertContext(net.minecraft.loot.LootContext info) {
        CraftEntity killer;
        Vector3d position = (Vector3d)info.func_216031_c(LootParameters.field_237457_g_);
        if (position == null) {
            position = ((Entity)info.func_216031_c(LootParameters.field_216281_a)).func_213303_ch();
        }
        Location location = new Location(info.func_202879_g().getWorld(), position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.func_216033_a(LootParameters.field_216284_d) && (killer = ((Entity)info.func_216031_c(LootParameters.field_216284_d)).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((CraftHumanEntity)killer);
        }
        if (info.func_216033_a(LootParameters.field_216281_a)) {
            contextBuilder.lootedEntity(((Entity)info.func_216031_c(LootParameters.field_216281_a)).getBukkitEntity());
        }
        if (info.func_216033_a(LootParameters.LOOTING_MOD)) {
            contextBuilder.lootingModifier((Integer)info.func_216031_c(LootParameters.LOOTING_MOD));
        }
        contextBuilder.luck(info.func_186491_f());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals(this.getKey());
    }
}

