/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;

public final class CraftRedstoneWire
extends CraftBlockData
implements RedstoneWire,
AnaloguePowerable {
    private static final EnumProperty<?> NORTH = CraftRedstoneWire.getEnum(RedstoneWireBlock.class, "north");
    private static final EnumProperty<?> EAST = CraftRedstoneWire.getEnum(RedstoneWireBlock.class, "east");
    private static final EnumProperty<?> SOUTH = CraftRedstoneWire.getEnum(RedstoneWireBlock.class, "south");
    private static final EnumProperty<?> WEST = CraftRedstoneWire.getEnum(RedstoneWireBlock.class, "west");
    private static final IntegerProperty POWER = CraftRedstoneWire.getInteger(RedstoneWireBlock.class, "power");

    public CraftRedstoneWire() {
    }

    public CraftRedstoneWire(BlockState state) {
        super(state);
    }

    @Override
    public RedstoneWire.Connection getFace(BlockFace face) {
        switch (face) {
            case NORTH: {
                return this.get(NORTH, RedstoneWire.Connection.class);
            }
            case EAST: {
                return this.get(EAST, RedstoneWire.Connection.class);
            }
            case SOUTH: {
                return this.get(SOUTH, RedstoneWire.Connection.class);
            }
            case WEST: {
                return this.get(WEST, RedstoneWire.Connection.class);
            }
        }
        throw new IllegalArgumentException("Cannot have face " + face);
    }

    @Override
    public void setFace(BlockFace face, RedstoneWire.Connection connection) {
        switch (face) {
            case NORTH: {
                this.set(NORTH, connection);
                break;
            }
            case EAST: {
                this.set(EAST, connection);
                break;
            }
            case SOUTH: {
                this.set(SOUTH, connection);
                break;
            }
            case WEST: {
                this.set(WEST, connection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot have face " + face);
            }
        }
    }

    @Override
    public Set<BlockFace> getAllowedFaces() {
        return ImmutableSet.of((Object)((Object)BlockFace.NORTH), (Object)((Object)BlockFace.EAST), (Object)((Object)BlockFace.SOUTH), (Object)((Object)BlockFace.WEST));
    }

    @Override
    public int getPower() {
        return (Integer)this.get(POWER);
    }

    @Override
    public void setPower(int power) {
        this.set(POWER, power);
    }

    @Override
    public int getMaximumPower() {
        return CraftRedstoneWire.getMax(POWER);
    }
}

