/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.GolemEntity;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftGolem;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;

public class CraftShulker
extends CraftGolem
implements Shulker {
    public CraftShulker(CraftServer server, ShulkerEntity entity) {
        super(server, (GolemEntity)entity);
    }

    @Override
    public String toString() {
        return "CraftShulker";
    }

    @Override
    public EntityType getType() {
        return EntityType.SHULKER;
    }

    public ShulkerEntity getHandle() {
        return (ShulkerEntity)this.entity;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.getByWoolData((Byte)this.getHandle().func_184212_Q().func_187225_a(ShulkerEntity.field_190770_bw));
    }

    @Override
    public void setColor(DyeColor color) {
        this.getHandle().func_184212_Q().func_187227_b(ShulkerEntity.field_190770_bw, (Object)(color == null ? (byte)16 : (byte)color.getWoolData()));
    }

    @Override
    public float getPeek() {
        return (float)this.getHandle().func_184684_db() / 100.0f;
    }

    @Override
    public void setPeek(float value) {
        Preconditions.checkArgument((value >= 0.0f && value <= 1.0f ? 1 : 0) != 0, (Object)"value needs to be in between or equal to 0 and 1");
        this.getHandle().func_184691_a((int)(value * 100.0f));
    }

    @Override
    public BlockFace getAttachedFace() {
        return CraftBlock.notchToBlockFace(this.getHandle().func_184696_cZ());
    }

    @Override
    public void setAttachedFace(BlockFace face) {
        Preconditions.checkNotNull((Object)((Object)face), (Object)"face cannot be null");
        Preconditions.checkArgument((boolean)face.isCartesian(), (String)"%s is not a valid block face to attach a shulker to, a cartesian block face is expected", (Object)((Object)face));
        this.getHandle().func_184212_Q().func_187227_b(ShulkerEntity.field_184700_a, (Object)CraftBlock.blockFaceToNotch(face));
    }
}

