/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.StriderEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Strider;

public class CraftStrider
extends CraftAnimals
implements Strider {
    public CraftStrider(CraftServer server, StriderEntity entity) {
        super(server, (AnimalEntity)entity);
    }

    @Override
    public boolean isShivering() {
        return this.getHandle().func_234315_eI_();
    }

    @Override
    public void setShivering(boolean shivering) {
        this.getHandle().func_234319_t_(shivering);
    }

    @Override
    public boolean hasSaddle() {
        return this.getHandle().func_230264_L__();
    }

    @Override
    public void setSaddle(boolean saddled) {
        this.getHandle().field_234313_bz_.func_233619_a_(saddled);
    }

    @Override
    public int getBoostTicks() {
        return this.getHandle().field_234313_bz_.field_233610_a_ ? this.getHandle().field_234313_bz_.field_233611_b_ : 0;
    }

    @Override
    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().field_234313_bz_.setBoostTicks(ticks);
    }

    @Override
    public int getCurrentBoostTicks() {
        return this.getHandle().field_234313_bz_.field_233610_a_ ? this.getHandle().field_234313_bz_.field_233611_b_ : 0;
    }

    @Override
    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().field_234313_bz_.field_233610_a_) {
            return;
        }
        int max = this.getHandle().field_234313_bz_.field_233611_b_;
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().field_234313_bz_.field_233611_b_ = ticks;
    }

    @Override
    public Material getSteerMaterial() {
        return Material.WARPED_FUNGUS_ON_A_STICK;
    }

    public StriderEntity getHandle() {
        return (StriderEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftStrider";
    }

    @Override
    public EntityType getType() {
        return EntityType.STRIDER;
    }
}

