/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import com.mohistmc.inventory.InventoryOwner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.inventory.InventoryIterator;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftLegacy;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;

public class CraftInventory
implements Inventory {
    protected final IInventory inventory;

    public CraftInventory(IInventory inventory) {
        this.inventory = inventory;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getInventory() == null ? 0 : this.getInventory().func_70302_i_();
    }

    @Override
    public ItemStack getItem(int index) {
        net.minecraft.item.ItemStack item = this.getInventory().func_70301_a(index);
        return item.func_190926_b() ? null : CraftItemStack.asCraftMirror(item);
    }

    protected ItemStack[] asCraftMirror(List<net.minecraft.item.ItemStack> mcItems) {
        int size = mcItems.size();
        ItemStack[] items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            net.minecraft.item.ItemStack mcItem = mcItems.get(i);
            items[i] = mcItem.func_190926_b() ? null : CraftItemStack.asCraftMirror(mcItem);
        }
        return items;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    @Override
    public ItemStack[] getContents() {
        List mcItems = this.getInventory().getContents();
        return this.asCraftMirror(mcItems);
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getSize() < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getSize() + " or less");
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (i >= items.length) {
                this.setItem(i, null);
                continue;
            }
            this.setItem(i, items[i]);
        }
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.getInventory().func_70299_a(index, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public boolean contains(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Material material, int amount) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        if (amount <= 0) {
            return true;
        }
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals(i) || --amount > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.isSimilar(i) || (amount -= i.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            slots.put(i, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getStorageContents();
            for (int i = 0; i < inventory.length; ++i) {
                if (!item.equals(inventory[i])) continue;
                slots.put(i, inventory[i]);
            }
        }
        return slots;
    }

    @Override
    public int first(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !(withAmount ? item.equals(inventory[i]) : item.isSimilar(inventory[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int firstEmpty() {
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.func_191420_l();
    }

    public int firstPartial(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material || item.getAmount() >= item.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getStorageContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack cItem = inventory[i];
            if (cItem == null || cItem.getAmount() >= cItem.getMaxStackSize() || !cItem.isSimilar(filteredItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Validate.noNullElements((Object[])items, (String)"Item cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block0;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    this.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                this.setItem(firstPartial, partialItem);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    @Override
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Validate.notNull((Object)items, (String)"Items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().func_70297_j_();
    }

    @Override
    public void remove(Material material) {
        Validate.notNull((Object)material, (String)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            this.clear(i);
        }
    }

    @Override
    public void remove(ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].equals(item)) continue;
            this.clear(i);
        }
    }

    @Override
    public void clear(int index) {
        this.setItem(index, null);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clear(i);
        }
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    @Override
    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    @Override
    public List<HumanEntity> getViewers() {
        try {
            return this.inventory.getViewers();
        }
        catch (AbstractMethodError e) {
            return new ArrayList<HumanEntity>();
        }
    }

    @Override
    public InventoryType getType() {
        if (this.inventory instanceof CraftingInventory) {
            return this.inventory.func_70302_i_() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof PlayerInventory) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof DropperTileEntity) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof DispenserTileEntity) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof BlastFurnaceTileEntity) {
            return InventoryType.BLAST_FURNACE;
        }
        if (this.inventory instanceof SmokerTileEntity) {
            return InventoryType.SMOKER;
        }
        if (this.inventory instanceof AbstractFurnaceTileEntity) {
            return InventoryType.FURNACE;
        }
        if (this instanceof CraftInventoryEnchanting) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof BrewingStandTileEntity) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof EnderChestInventory) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof MerchantInventory) {
            return InventoryType.MERCHANT;
        }
        if (this instanceof CraftInventoryBeacon) {
            return InventoryType.BEACON;
        }
        if (this instanceof CraftInventoryAnvil) {
            return InventoryType.ANVIL;
        }
        if (this instanceof CraftInventorySmithing) {
            return InventoryType.SMITHING;
        }
        if (this.inventory instanceof IHopper) {
            return InventoryType.HOPPER;
        }
        if (this.inventory instanceof ShulkerBoxTileEntity) {
            return InventoryType.SHULKER_BOX;
        }
        if (this.inventory instanceof BarrelTileEntity) {
            return InventoryType.BARREL;
        }
        if (this.inventory instanceof LecternTileEntity.LecternInventory) {
            return InventoryType.LECTERN;
        }
        if (this instanceof CraftInventoryLoom) {
            return InventoryType.LOOM;
        }
        if (this instanceof CraftInventoryCartography) {
            return InventoryType.CARTOGRAPHY;
        }
        if (this instanceof CraftInventoryGrindstone) {
            return InventoryType.GRINDSTONE;
        }
        if (this instanceof CraftInventoryStonecutter) {
            return InventoryType.STONECUTTER;
        }
        return InventoryType.CHEST;
    }

    @Override
    public InventoryHolder getHolder() {
        return InventoryOwner.get(this.inventory);
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.func_70297_j_();
    }

    @Override
    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftInventory && ((CraftInventory)obj).inventory.equals(this.inventory);
    }

    @Override
    public Location getLocation() {
        if (this.inventory instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)this.inventory;
            return new Location(tileEntity.func_145831_w().getWorld(), tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p());
        }
        return this.inventory.getLocation();
    }
}

