/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.mohistmc.bukkit.nms.ClassLoaderContext;
import com.mohistmc.bukkit.nms.utils.RemapUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final ClassLoader libraryLoader;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private final Set<String> seenIllegalAccess = Collections.newSetFromMap(new ConcurrentHashMap());

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    PluginClassLoader(@NotNull JavaPluginLoader loader, @Nullable ClassLoader parent, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file, @Nullable ClassLoader libraryLoader) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.libraryLoader = libraryLoader;
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", ex);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true, true);
    }

    Class<?> loadClass0(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> result;
            if (checkLibraries && this.libraryLoader != null) {
                try {
                    return this.libraryLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
            if (checkGlobal && (result = this.loader.getClassByName(name, resolve, this.description)) != null) {
                PluginDescriptionFile provider = ((PluginClassLoader)result.getClassLoader()).description;
                if (provider != this.description && !this.seenIllegalAccess.contains(provider.getName()) && !((SimplePluginManager)this.loader.server.getPluginManager()).isTransitiveDepend(this.description, provider)) {
                    this.seenIllegalAccess.add(provider.getName());
                    if (this.plugin != null) {
                        this.plugin.getLogger().log(Level.WARNING, "Loaded class {0} from {1} which is not a depend, softdepend or loadbefore of this plugin.", new Object[]{name, provider.getFullName()});
                    } else {
                        this.loader.server.getLogger().log(Level.WARNING, "[{0}] Loaded class {1} from {2} which is not a depend, softdepend or loadbefore of this plugin.", new Object[]{this.description.getName(), name, provider.getFullName()});
                    }
                }
                return result;
            }
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        ClassLoaderContext.put(this);
        try {
            if (name.replace("/", ".").startsWith("net.minecraft.server.v1_16_R3.")) {
                String remappedClass = RemapUtils.jarMapping.byNMSName.get(name).getMcpName();
                Class<?> clazz = Class.forName(remappedClass);
                return clazz;
            }
            if (name.startsWith("org.bukkit.")) {
                throw new ClassNotFoundException(name);
            }
            result = this.classes.get(name);
            String string = name.intern();
            synchronized (string) {
                if (result == null) {
                    if (result == null) {
                        result = this.remappedFindClass(name);
                    }
                    if (result != null) {
                        this.loader.setClass(name, result);
                    }
                    if (result == null) {
                        try {
                            result = MinecraftServer.getServer().getClass().getClassLoader().loadClass(name);
                        }
                        catch (Throwable throwable) {
                            throw new ClassNotFoundException(name, throwable);
                        }
                    }
                    this.loader.setClass(name, result);
                    this.classes.put(name, result);
                }
            }
        }
        finally {
            ClassLoaderContext.pop();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    @NotNull
    Collection<Class<?>> getClasses() {
        return this.classes.values();
    }

    synchronized void initialize(@NotNull JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    private Class<?> remappedFindClass(String name) {
        Class<?> result;
        block8: {
            result = null;
            try {
                CodeSource codeSource;
                URL jarURL;
                byte[] bytecode;
                block9: {
                    String pkgName;
                    InputStream stream;
                    String path = name.replace('.', '/').concat(".class");
                    URL url = this.findResource(path);
                    if (url == null || (stream = url.openStream()) == null) break block8;
                    bytecode = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                    bytecode = this.loader.server.getUnsafe().processClass(this.description, path, bytecode);
                    bytecode = RemapUtils.remapFindClass(bytecode);
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    jarURL = jarURLConnection.getJarFileURL();
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                        try {
                            if (this.manifest != null) {
                                this.definePackage(pkgName, this.manifest, url);
                            } else {
                                this.definePackage(pkgName, null, null, null, null, null, null, null);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.getPackage(pkgName) != null) break block9;
                            throw new IllegalStateException("Cannot find package " + pkgName);
                        }
                    }
                }
                if ((result = this.defineClass(name, bytecode, 0, bytecode.length, codeSource = new CodeSource(jarURL, new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        return result;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

