/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import com.mohistmc.util.i18n.i18n;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.SpigotConfig;

public class SpigotWorldConfig {
    private final String worldName;
    private final YamlConfiguration config;
    private boolean verbose;
    public int cactusModifier;
    public int caneModifier;
    public int melonModifier;
    public int mushroomModifier;
    public int pumpkinModifier;
    public int saplingModifier;
    public int beetrootModifier;
    public int carrotModifier;
    public int potatoModifier;
    public int wheatModifier;
    public int wartModifier;
    public int vineModifier;
    public int cocoaModifier;
    public int bambooModifier;
    public int sweetBerryModifier;
    public int kelpModifier;
    public double itemMerge;
    public double expMerge;
    public int viewDistance;
    public byte mobSpawnRange;
    public int itemDespawnRate;
    public int animalActivationRange = 32;
    public int monsterActivationRange = 32;
    public int raiderActivationRange = 48;
    public int miscActivationRange = 16;
    public boolean tickInactiveVillagers = true;
    public int playerTrackingRange = 48;
    public int animalTrackingRange = 48;
    public int monsterTrackingRange = 48;
    public int miscTrackingRange = 32;
    public int otherTrackingRange = 64;
    public int hopperTransfer;
    public int hopperCheck;
    public int hopperAmount;
    public int arrowDespawnRate;
    public int tridentDespawnRate;
    public boolean zombieAggressiveTowardsVillager;
    public boolean nerfSpawnerMobs;
    public boolean enableZombiePigmenPortalSpawns;
    public int dragonDeathSoundRadius;
    public int witherSpawnSoundRadius;
    public int endPortalSoundRadius;
    public int villageSeed;
    public int desertSeed;
    public int iglooSeed;
    public int jungleSeed;
    public int swampSeed;
    public int monumentSeed;
    public int oceanSeed;
    public int outpostSeed;
    public int shipwreckSeed;
    public int slimeSeed;
    public int endCitySeed;
    public int bastionSeed;
    public int fortressSeed;
    public int mansionSeed;
    public int fossilSeed;
    public int portalSeed;
    public float jumpWalkExhaustion;
    public float jumpSprintExhaustion;
    public float combatExhaustion;
    public float regenExhaustion;
    public float swimMultiplier;
    public float sprintMultiplier;
    public float otherMultiplier;
    public int currentPrimedTnt = 0;
    public int maxTntTicksPerTick;
    public int hangingTickFrequency;
    public int tileMaxTickTime;
    public int entityMaxTickTime;
    public double squidSpawnRangeMin;

    public SpigotWorldConfig(String worldName) {
        this.worldName = worldName;
        this.config = SpigotConfig.config;
        this.init();
    }

    public void init() {
        this.verbose = this.getBoolean("verbose", false);
        this.log("-------- " + i18n.get((String)"spigotworldconfig.1", (Object[])new Object[]{this.worldName}) + " --------");
        SpigotConfig.readConfig(SpigotWorldConfig.class, this);
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path) {
        return this.config.getInt("world-settings." + this.worldName + "." + path);
    }

    private int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private Object get(String path, Object def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.get("world-settings." + this.worldName + "." + path, this.config.get("world-settings.default." + path));
    }

    private int getAndValidateGrowth(String crop) {
        int modifier = this.getInt("growth." + crop.toLowerCase(Locale.ENGLISH) + "-modifier", 100);
        if (modifier == 0) {
            this.log("Cannot set " + crop + " growth to zero, defaulting to 100");
            modifier = 100;
        }
        this.log(crop + " " + i18n.get((String)"spigotworldconfig.8") + " " + modifier + "%");
        return modifier;
    }

    private void growthModifiers() {
        this.cactusModifier = this.getAndValidateGrowth("Cactus");
        this.caneModifier = this.getAndValidateGrowth("Cane");
        this.melonModifier = this.getAndValidateGrowth("Melon");
        this.mushroomModifier = this.getAndValidateGrowth("Mushroom");
        this.pumpkinModifier = this.getAndValidateGrowth("Pumpkin");
        this.saplingModifier = this.getAndValidateGrowth("Sapling");
        this.beetrootModifier = this.getAndValidateGrowth("Beetroot");
        this.carrotModifier = this.getAndValidateGrowth("Carrot");
        this.potatoModifier = this.getAndValidateGrowth("Potato");
        this.wheatModifier = this.getAndValidateGrowth("Wheat");
        this.wartModifier = this.getAndValidateGrowth("NetherWart");
        this.vineModifier = this.getAndValidateGrowth("Vine");
        this.cocoaModifier = this.getAndValidateGrowth("Cocoa");
        this.bambooModifier = this.getAndValidateGrowth("Bamboo");
        this.sweetBerryModifier = this.getAndValidateGrowth("SweetBerry");
        this.kelpModifier = this.getAndValidateGrowth("Kelp");
    }

    private void itemMerge() {
        this.itemMerge = this.getDouble("merge-radius.item", 2.5);
        this.log(i18n.get((String)"spigotworldconfig.7") + " " + this.itemMerge);
    }

    private void expMerge() {
        this.expMerge = this.getDouble("merge-radius.exp", 3.0);
        this.log(i18n.get((String)"spigotworldconfig.6") + " " + this.expMerge);
    }

    private void viewDistance() {
        Object viewDistanceObject;
        if (SpigotConfig.version < 12) {
            this.set("view-distance", null);
        }
        int n = this.viewDistance = (viewDistanceObject = this.get("view-distance", "default")) instanceof Number ? ((Number)viewDistanceObject).intValue() : -1;
        if (this.viewDistance <= 0) {
            this.viewDistance = Bukkit.getViewDistance();
        }
        this.viewDistance = Math.max(Math.min(this.viewDistance, 32), 3);
        this.log(i18n.get((String)"spigotworldconfig.5") + " " + this.viewDistance);
    }

    private void mobSpawnRange() {
        this.mobSpawnRange = (byte)this.getInt("mob-spawn-range", 6);
        this.log(i18n.get((String)"spigotworldconfig.4") + " " + this.mobSpawnRange);
    }

    private void itemDespawnRate() {
        this.itemDespawnRate = this.getInt("item-despawn-rate", 6000);
        this.log(i18n.get((String)"spigotworldconfig.3") + " " + this.itemDespawnRate);
    }

    private void activationRange() {
        this.animalActivationRange = this.getInt("entity-activation-range.animals", this.animalActivationRange);
        this.monsterActivationRange = this.getInt("entity-activation-range.monsters", this.monsterActivationRange);
        this.raiderActivationRange = this.getInt("entity-activation-range.raiders", this.raiderActivationRange);
        this.miscActivationRange = this.getInt("entity-activation-range.misc", this.miscActivationRange);
        this.tickInactiveVillagers = this.getBoolean("entity-activation-range.tick-inactive-villagers", this.tickInactiveVillagers);
        this.log(i18n.get((String)"spigotworldconfig.2") + " An " + this.animalActivationRange + " / Mo " + this.monsterActivationRange + " / Ra " + this.raiderActivationRange + " / Mi " + this.miscActivationRange + " / Tiv " + this.tickInactiveVillagers);
    }

    private void trackingRange() {
        this.playerTrackingRange = this.getInt("entity-tracking-range.players", this.playerTrackingRange);
        this.animalTrackingRange = this.getInt("entity-tracking-range.animals", this.animalTrackingRange);
        this.monsterTrackingRange = this.getInt("entity-tracking-range.monsters", this.monsterTrackingRange);
        this.miscTrackingRange = this.getInt("entity-tracking-range.misc", this.miscTrackingRange);
        this.otherTrackingRange = this.getInt("entity-tracking-range.other", this.otherTrackingRange);
        this.log(i18n.get((String)"spigotworldconfig.9") + " Pl " + this.playerTrackingRange + " / An " + this.animalTrackingRange + " / Mo " + this.monsterTrackingRange + " / Mi " + this.miscTrackingRange + " / Other " + this.otherTrackingRange);
    }

    private void hoppers() {
        this.hopperTransfer = this.getInt("ticks-per.hopper-transfer", 8);
        if (SpigotConfig.version < 11) {
            this.set("ticks-per.hopper-check", 1);
        }
        this.hopperCheck = this.getInt("ticks-per.hopper-check", 1);
        this.hopperAmount = this.getInt("hopper-amount", 1);
        this.log(i18n.get((String)"spigotworldconfig.10", (Object[])new Object[]{this.hopperTransfer, this.hopperCheck, this.hopperAmount}));
    }

    private void arrowDespawnRate() {
        this.arrowDespawnRate = this.getInt("arrow-despawn-rate", 1200);
        this.tridentDespawnRate = this.getInt("trident-despawn-rate", this.arrowDespawnRate);
        this.log(i18n.get((String)"spigotworldconfig.11", (Object[])new Object[]{this.arrowDespawnRate, this.tridentDespawnRate}));
    }

    private void zombieAggressiveTowardsVillager() {
        this.zombieAggressiveTowardsVillager = this.getBoolean("zombie-aggressive-towards-villager", true);
        this.log(i18n.get((String)"spigotworldconfig.12") + " " + this.zombieAggressiveTowardsVillager);
    }

    private void nerfSpawnerMobs() {
        this.nerfSpawnerMobs = this.getBoolean("nerf-spawner-mobs", false);
        this.log(i18n.get((String)"spigotworldconfig.13") + " " + this.nerfSpawnerMobs);
    }

    private void enableZombiePigmenPortalSpawns() {
        this.enableZombiePigmenPortalSpawns = this.getBoolean("enable-zombie-pigmen-portal-spawns", true);
        this.log(i18n.get((String)"spigotworldconfig.14") + " " + this.enableZombiePigmenPortalSpawns);
    }

    private void keepDragonDeathPerWorld() {
        this.dragonDeathSoundRadius = this.getInt("dragon-death-sound-radius", 0);
    }

    private void witherSpawnSoundRadius() {
        this.witherSpawnSoundRadius = this.getInt("wither-spawn-sound-radius", 0);
    }

    private void endPortalSoundRadius() {
        this.endPortalSoundRadius = this.getInt("end-portal-sound-radius", 0);
    }

    private void initWorldGenSeeds() {
        this.villageSeed = this.getInt("seed-village", 10387312);
        this.desertSeed = this.getInt("seed-desert", 14357617);
        this.iglooSeed = this.getInt("seed-igloo", 14357618);
        this.jungleSeed = this.getInt("seed-jungle", 14357619);
        this.swampSeed = this.getInt("seed-swamp", 14357620);
        this.monumentSeed = this.getInt("seed-monument", 10387313);
        this.shipwreckSeed = this.getInt("seed-shipwreck", 165745295);
        this.oceanSeed = this.getInt("seed-ocean", 14357621);
        this.outpostSeed = this.getInt("seed-outpost", 165745296);
        this.endCitySeed = this.getInt("seed-endcity", 10387313);
        this.slimeSeed = this.getInt("seed-slime", 987234911);
        this.bastionSeed = this.getInt("seed-bastion", 30084232);
        this.fortressSeed = this.getInt("seed-fortress", 30084232);
        this.mansionSeed = this.getInt("seed-mansion", 10387319);
        this.fossilSeed = this.getInt("seed-fossil", 14357921);
        this.portalSeed = this.getInt("seed-portal", 34222645);
        this.log(i18n.get((String)"spigotworldconfig.15", (Object[])new Object[]{this.villageSeed, this.desertSeed, this.iglooSeed, this.jungleSeed, this.swampSeed, this.monumentSeed, this.oceanSeed, this.shipwreckSeed, this.endCitySeed, this.slimeSeed, this.bastionSeed, this.fortressSeed, this.mansionSeed, this.fossilSeed, this.portalSeed}));
    }

    private void initHunger() {
        if (SpigotConfig.version < 10) {
            this.set("hunger.walk-exhaustion", null);
            this.set("hunger.sprint-exhaustion", null);
            this.set("hunger.combat-exhaustion", 0.1);
            this.set("hunger.regen-exhaustion", 6.0);
        }
        this.jumpWalkExhaustion = (float)this.getDouble("hunger.jump-walk-exhaustion", 0.05);
        this.jumpSprintExhaustion = (float)this.getDouble("hunger.jump-sprint-exhaustion", 0.2);
        this.combatExhaustion = (float)this.getDouble("hunger.combat-exhaustion", 0.1);
        this.regenExhaustion = (float)this.getDouble("hunger.regen-exhaustion", 6.0);
        this.swimMultiplier = (float)this.getDouble("hunger.swim-multiplier", 0.01);
        this.sprintMultiplier = (float)this.getDouble("hunger.sprint-multiplier", 0.1);
        this.otherMultiplier = (float)this.getDouble("hunger.other-multiplier", 0.0);
    }

    private void maxTntPerTick() {
        if (SpigotConfig.version < 7) {
            this.set("max-tnt-per-tick", 100);
        }
        this.maxTntTicksPerTick = this.getInt("max-tnt-per-tick", 100);
        this.log("Max TNT Explosions: " + this.maxTntTicksPerTick);
    }

    private void hangingTickFrequency() {
        this.hangingTickFrequency = this.getInt("hanging-tick-frequency", 100);
    }

    private void maxTickTimes() {
        this.tileMaxTickTime = this.getInt("max-tick-time.tile", 50);
        this.entityMaxTickTime = this.getInt("max-tick-time.entity", 50);
        this.log(i18n.get((String)"spigotworldconfig.16", (Object[])new Object[]{this.tileMaxTickTime, this.entityMaxTickTime}));
    }

    private void squidSpawnRange() {
        this.squidSpawnRangeMin = this.getDouble("squid-spawn-range.min", 45.0);
    }
}

