/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IoUtil {
    private static final Logger LOGGER = LogManager.getLogger(IoUtil.class);
    private static final int DEFAULT_EXTRACT_FLAGS = 1;

    private IoUtil() {
    }

    public static IStackList<ItemStack> extractFromInternalItemStorage(IStackList<ItemStack> list, IStorageDisk<ItemStack> storage, Action action) {
        IStackList<ItemStack> extracted = API.instance().createItemStackList();
        for (StackListEntry<ItemStack> entry : list.getStacks()) {
            ItemStack result = storage.extract(entry.getStack(), entry.getStack().func_190916_E(), 1, action);
            if (result.func_190926_b() || result.func_190916_E() != entry.getStack().func_190916_E()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static IStackList<FluidStack> extractFromInternalFluidStorage(IStackList<FluidStack> list, IStorageDisk<FluidStack> storage, Action action) {
        IStackList<FluidStack> extracted = API.instance().createFluidStackList();
        for (StackListEntry<FluidStack> entry : list.getStacks()) {
            FluidStack result = storage.extract(entry.getStack(), entry.getStack().getAmount(), 1, action);
            if (result.isEmpty() || result.getAmount() != entry.getStack().getAmount()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static boolean insertIntoInventory(@Nullable IItemHandler dest, Collection<StackListEntry<ItemStack>> toInsert, Action action) {
        boolean success;
        if (dest == null) {
            return false;
        }
        if (toInsert.isEmpty()) {
            return true;
        }
        ArrayDeque<StackListEntry<ItemStack>> stacks = new ArrayDeque<StackListEntry<ItemStack>>(toInsert);
        StackListEntry currentEntry = (StackListEntry)stacks.poll();
        ItemStack current = currentEntry != null ? (ItemStack)currentEntry.getStack() : null;
        List availableSlots = IntStream.range(0, dest.getSlots()).boxed().collect(Collectors.toList());
        while (current != null && !availableSlots.isEmpty()) {
            ItemStack remainder = ItemStack.field_190927_a;
            for (int i = 0; i < availableSlots.size(); ++i) {
                int slot = (Integer)availableSlots.get(i);
                remainder = dest.insertItem(slot, current.func_77946_l(), action == Action.SIMULATE);
                if (!remainder.func_190926_b() && current.func_190916_E() == remainder.func_190916_E()) continue;
                availableSlots.remove(i);
                break;
            }
            if (remainder.func_190926_b()) {
                currentEntry = (StackListEntry)stacks.poll();
                current = currentEntry != null ? (ItemStack)currentEntry.getStack() : null;
                continue;
            }
            if (current.func_190916_E() == remainder.func_190916_E()) break;
            current = remainder;
        }
        boolean bl = success = current == null && stacks.isEmpty();
        if (!success && action == Action.PERFORM) {
            LOGGER.warn("Inventory unexpectedly didn't accept {}, the remainder has been voided!", (Object)(current != null ? current.func_77977_a() : null));
        }
        return success;
    }

    public static boolean insertIntoInventory(IFluidHandler dest, Collection<StackListEntry<FluidStack>> toInsert, Action action) {
        for (StackListEntry<FluidStack> entry : toInsert) {
            int filled = dest.fill(entry.getStack(), action == Action.SIMULATE ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (filled == entry.getStack().getAmount()) continue;
            if (action == Action.PERFORM) {
                LOGGER.warn("Inventory unexpectedly didn't accept all of {}, the remainder has been voided!", (Object)entry.getStack().getTranslationKey());
            }
            return false;
        }
        return true;
    }

    public static void extractItemsFromNetwork(IStackList<ItemStack> toExtractInitial, INetwork network, IStorageDisk<ItemStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (StackListEntry<ItemStack> toExtract : toExtractInitial.getStacks()) {
            ItemStack result = network.extractItem(toExtract.getStack(), toExtract.getStack().func_190916_E(), Action.PERFORM);
            if (result.func_190926_b()) continue;
            internalStorage.insert(toExtract.getStack(), result.func_190916_E(), Action.PERFORM);
            toRemove.add(result);
        }
        for (ItemStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }

    public static void extractFluidsFromNetwork(IStackList<FluidStack> toExtractInitial, INetwork network, IStorageDisk<FluidStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<FluidStack> toRemove = new ArrayList<FluidStack>();
        for (StackListEntry<FluidStack> toExtract : toExtractInitial.getStacks()) {
            FluidStack result = network.extractFluid(toExtract.getStack(), toExtract.getStack().getAmount(), Action.PERFORM);
            if (result.isEmpty()) continue;
            internalStorage.insert(result, result.getAmount(), Action.PERFORM);
            toRemove.add(result);
        }
        for (FluidStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }
}

