/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.google.common.primitives.Ints;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;

public class NodeRequirements {
    private static final String NBT_ITEMS_TO_USE = "ItemsToUse";
    private static final String NBT_FLUIDS_TO_USE = "FluidsToUse";
    private static final String NBT_ITEMS_NEEDED_PER_CRAFT = "ItemsNeededPerCraft";
    private static final String NBT_FLUIDS_NEEDED_PER_CRAFT = "FluidsNeededPerCraft";
    private final Map<Integer, IStackList<ItemStack>> itemRequirements = new LinkedHashMap<Integer, IStackList<ItemStack>>();
    private final Map<Integer, Integer> itemsNeededPerCraft = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, IStackList<FluidStack>> fluidRequirements = new LinkedHashMap<Integer, IStackList<FluidStack>>();
    private final Map<Integer, Integer> fluidsNeededPerCraft = new LinkedHashMap<Integer, Integer>();

    public void addItemRequirement(int ingredientNumber, ItemStack stack, int size, int perCraft) {
        if (!this.itemsNeededPerCraft.containsKey(ingredientNumber)) {
            this.itemsNeededPerCraft.put(ingredientNumber, perCraft);
        }
        IStackList list = this.itemRequirements.computeIfAbsent(ingredientNumber, key -> API.instance().createItemStackList());
        list.add(stack, size);
    }

    public void addFluidRequirement(int ingredientNumber, FluidStack stack, int size, int perCraft) {
        if (!this.fluidsNeededPerCraft.containsKey(ingredientNumber)) {
            this.fluidsNeededPerCraft.put(ingredientNumber, perCraft);
        }
        IStackList list = this.fluidRequirements.computeIfAbsent(ingredientNumber, key -> API.instance().createFluidStackList());
        list.add(stack, size);
    }

    public IStackList<ItemStack> getSingleItemRequirementSet(boolean simulate) {
        IStackList<ItemStack> toReturn = API.instance().createItemStackList();
        for (int i = 0; i < this.itemRequirements.size(); ++i) {
            int needed = this.itemsNeededPerCraft.get(i);
            if (!this.itemRequirements.get(i).isEmpty()) {
                Iterator<StackListEntry<ItemStack>> it = this.itemRequirements.get(i).getStacks().iterator();
                while (needed > 0 && it.hasNext()) {
                    ItemStack toUse = it.next().getStack();
                    if (needed < toUse.func_190916_E()) {
                        if (!simulate) {
                            this.itemRequirements.get(i).remove(toUse, needed);
                        }
                        toReturn.add(toUse, needed);
                        needed = 0;
                        continue;
                    }
                    if (!simulate) {
                        it.remove();
                    }
                    toReturn.add(toUse);
                    needed -= toUse.func_190916_E();
                }
                continue;
            }
            throw new IllegalStateException("Bad!");
        }
        return toReturn;
    }

    public IStackList<FluidStack> getSingleFluidRequirementSet(boolean simulate) {
        IStackList<FluidStack> toReturn = API.instance().createFluidStackList();
        for (int i = 0; i < this.fluidRequirements.size(); ++i) {
            int needed = this.fluidsNeededPerCraft.get(i);
            if (!this.fluidRequirements.get(i).isEmpty()) {
                Iterator<StackListEntry<FluidStack>> it = this.fluidRequirements.get(i).getStacks().iterator();
                while (needed > 0 && it.hasNext()) {
                    FluidStack toUse = it.next().getStack();
                    if (needed < toUse.getAmount()) {
                        if (!simulate) {
                            this.fluidRequirements.get(i).remove(toUse, needed);
                        }
                        toReturn.add(toUse, needed);
                        needed = 0;
                        continue;
                    }
                    if (!simulate) {
                        it.remove();
                    }
                    toReturn.add(toUse);
                    needed -= toUse.getAmount();
                }
                continue;
            }
            throw new IllegalStateException("Bad!");
        }
        return toReturn;
    }

    public void readFromNbt(CompoundNBT tag) throws CraftingTaskReadException {
        ListNBT itemRequirementsTag = tag.func_150295_c(NBT_ITEMS_TO_USE, 9);
        for (int i = 0; i < itemRequirementsTag.size(); ++i) {
            this.itemRequirements.put(i, SerializationUtil.readItemStackList(itemRequirementsTag.func_202169_e(i)));
        }
        List itemsNeededPerCraftTag = Ints.asList((int[])tag.func_74759_k(NBT_ITEMS_NEEDED_PER_CRAFT));
        for (int i = 0; i < itemsNeededPerCraftTag.size(); ++i) {
            this.itemsNeededPerCraft.put(i, (Integer)itemsNeededPerCraftTag.get(i));
        }
        ListNBT fluidRequirementsTag = tag.func_150295_c(NBT_FLUIDS_TO_USE, 9);
        for (int i = 0; i < fluidRequirementsTag.size(); ++i) {
            this.fluidRequirements.put(i, SerializationUtil.readFluidStackList(fluidRequirementsTag.func_202169_e(i)));
        }
        List fluidsNeededPerCraftTag = Ints.asList((int[])tag.func_74759_k(NBT_FLUIDS_NEEDED_PER_CRAFT));
        for (int i = 0; i < fluidsNeededPerCraftTag.size(); ++i) {
            this.fluidsNeededPerCraft.put(i, (Integer)fluidsNeededPerCraftTag.get(i));
        }
    }

    public CompoundNBT writeToNbt(CompoundNBT tag) {
        ListNBT itemRequirementsTag = new ListNBT();
        for (IStackList<ItemStack> list : this.itemRequirements.values()) {
            itemRequirementsTag.add((Object)SerializationUtil.writeItemStackList(list));
        }
        tag.func_218657_a(NBT_ITEMS_TO_USE, (INBT)itemRequirementsTag);
        tag.func_74783_a(NBT_ITEMS_NEEDED_PER_CRAFT, Ints.toArray(this.itemsNeededPerCraft.values()));
        ListNBT fluidRequirementsTag = new ListNBT();
        for (IStackList<FluidStack> list : this.fluidRequirements.values()) {
            fluidRequirementsTag.add((Object)SerializationUtil.writeFluidStackList(list));
        }
        tag.func_218657_a(NBT_FLUIDS_TO_USE, (INBT)fluidRequirementsTag);
        tag.func_74783_a(NBT_FLUIDS_NEEDED_PER_CRAFT, Ints.toArray(this.fluidsNeededPerCraft.values()));
        return tag;
    }
}

