/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.IoUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.SerializationUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingNode
extends Node {
    private static final String NBT_ITEMS_RECEIVED = "ItemsReceived";
    private static final String NBT_FLUIDS_RECEIVED = "FluidsReceived";
    private static final String NBT_SINGLE_ITEM_SET_TO_REQUIRE = "SingleItemSetToRequire";
    private static final String NBT_SINGLE_FLUID_SET_TO_REQUIRE = "SingleFluidSetToRequire";
    private static final String NBT_STATE = "State";
    private final IStackList<ItemStack> singleItemSetToReceive = API.instance().createItemStackList();
    private final IStackList<FluidStack> singleFluidSetToReceive = API.instance().createFluidStackList();
    private IStackList<ItemStack> singleItemSetToRequire;
    private IStackList<FluidStack> singleFluidSetToRequire;
    private IStackList<ItemStack> itemsReceived = API.instance().createItemStackList();
    private IStackList<FluidStack> fluidsReceived = API.instance().createFluidStackList();
    private ProcessingState state = ProcessingState.READY;
    private int quantityFinished;

    public ProcessingNode(ICraftingPattern pattern, boolean root) {
        super(pattern, root);
        this.initSetsToReceive();
    }

    public ProcessingNode(INetwork network, CompoundNBT tag) throws CraftingTaskReadException {
        super(network, tag);
        this.itemsReceived = SerializationUtil.readItemStackList(tag.func_150295_c(NBT_ITEMS_RECEIVED, 10));
        this.fluidsReceived = SerializationUtil.readFluidStackList(tag.func_150295_c(NBT_FLUIDS_RECEIVED, 10));
        this.singleItemSetToRequire = SerializationUtil.readItemStackList(tag.func_150295_c(NBT_SINGLE_ITEM_SET_TO_REQUIRE, 10));
        this.singleFluidSetToRequire = SerializationUtil.readFluidStackList(tag.func_150295_c(NBT_SINGLE_FLUID_SET_TO_REQUIRE, 10));
        this.state = ProcessingState.values()[tag.func_74762_e(NBT_STATE)];
        this.initSetsToReceive();
    }

    private void initSetsToReceive() {
        for (ItemStack output : this.getPattern().getOutputs()) {
            this.singleItemSetToReceive.add(output, output.func_190916_E());
        }
        for (ItemStack output : this.getPattern().getFluidOutputs()) {
            this.singleFluidSetToReceive.add((FluidStack)output, output.getAmount());
        }
    }

    @Override
    public void update(INetwork network, int ticks, NodeList nodes, IStorageDisk<ItemStack> internalStorage, IStorageDisk<FluidStack> internalFluidStorage, NodeListener listener) {
        if (this.getQuantity() <= 0) {
            if (this.state == ProcessingState.PROCESSED) {
                listener.onAllDone(this);
            }
            return;
        }
        boolean allLocked = true;
        boolean allMissingMachine = true;
        boolean allRejected = true;
        ProcessingState originalState = this.state;
        block0: for (ICraftingPatternContainer container : network.getCraftingManager().getAllContainers(this.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates(); ++i) {
                if (this.getQuantity() <= 0) {
                    return;
                }
                if (container.isLocked()) {
                    if (!allLocked) continue block0;
                    this.state = ProcessingState.LOCKED;
                    continue block0;
                }
                allLocked = false;
                if (!this.singleItemSetToRequire.isEmpty() && container.getConnectedInventory() == null || !this.singleFluidSetToRequire.isEmpty() && container.getConnectedFluidInventory() == null) {
                    if (!allMissingMachine) continue block0;
                    this.state = ProcessingState.MACHINE_NONE;
                    continue block0;
                }
                allMissingMachine = false;
                boolean hasAllRequirements = false;
                IStackList<ItemStack> extractedItems = IoUtil.extractFromInternalItemStorage(this.requirements.getSingleItemRequirementSet(true), internalStorage, Action.SIMULATE);
                IStackList<FluidStack> extractedFluids = null;
                if (extractedItems != null && (extractedFluids = IoUtil.extractFromInternalFluidStorage(this.requirements.getSingleFluidRequirementSet(true), internalFluidStorage, Action.SIMULATE)) != null) {
                    hasAllRequirements = true;
                }
                boolean canInsertFullAmount = false;
                if (hasAllRequirements && (canInsertFullAmount = IoUtil.insertIntoInventory(container.getConnectedInventory(), extractedItems.getStacks(), Action.SIMULATE))) {
                    canInsertFullAmount = IoUtil.insertIntoInventory(container.getConnectedFluidInventory(), extractedFluids.getStacks(), Action.SIMULATE);
                }
                if (hasAllRequirements && !canInsertFullAmount) {
                    if (!allRejected) continue block0;
                    this.state = ProcessingState.MACHINE_DOES_NOT_ACCEPT;
                    continue block0;
                }
                allRejected = false;
                if (!hasAllRequirements || !canInsertFullAmount) continue;
                this.state = ProcessingState.READY;
                extractedItems = IoUtil.extractFromInternalItemStorage(this.requirements.getSingleItemRequirementSet(false), internalStorage, Action.PERFORM);
                extractedFluids = IoUtil.extractFromInternalFluidStorage(this.requirements.getSingleFluidRequirementSet(false), internalFluidStorage, Action.PERFORM);
                IoUtil.insertIntoInventory(container.getConnectedInventory(), extractedItems.getStacks(), Action.PERFORM);
                IoUtil.insertIntoInventory(container.getConnectedFluidInventory(), extractedFluids.getStacks(), Action.PERFORM);
                this.next();
                listener.onSingleDone(this);
                container.onUsedForProcessing();
            }
        }
        if (originalState != this.state) {
            network.getCraftingManager().onTaskChanged();
        }
    }

    public ProcessingState getState() {
        return this.state;
    }

    public IStackList<ItemStack> getSingleItemSetToReceive() {
        return this.singleItemSetToReceive;
    }

    public IStackList<FluidStack> getSingleFluidSetToReceive() {
        return this.singleFluidSetToReceive;
    }

    public IStackList<ItemStack> getSingleItemSetToRequire() {
        return this.singleItemSetToRequire;
    }

    public IStackList<FluidStack> getSingleFluidSetToRequire() {
        return this.singleFluidSetToRequire;
    }

    public int getNeeded(ItemStack stack) {
        return this.singleItemSetToReceive.getCount(stack) * this.totalQuantity - this.itemsReceived.getCount(stack);
    }

    public int getNeeded(FluidStack stack) {
        return this.singleFluidSetToReceive.getCount(stack) * this.totalQuantity - this.fluidsReceived.getCount(stack);
    }

    public int getCurrentlyProcessing() {
        int unprocessed = this.totalQuantity - this.quantity;
        return unprocessed - this.quantityFinished;
    }

    public void markReceived(ItemStack stack, int count) {
        this.itemsReceived.add(stack, count);
        this.updateFinishedQuantity();
    }

    public void markReceived(FluidStack stack, int count) {
        this.fluidsReceived.add(stack, count);
        this.updateFinishedQuantity();
    }

    public void updateFinishedQuantity() {
        int ratioReceived;
        int tempQuantityFinished = this.totalQuantity;
        for (StackListEntry<ItemStack> stackListEntry : this.singleItemSetToReceive.getStacks()) {
            if (this.itemsReceived.get(stackListEntry.getStack()) != null) {
                ratioReceived = this.itemsReceived.get(stackListEntry.getStack()).func_190916_E() / stackListEntry.getStack().func_190916_E();
                if (tempQuantityFinished <= ratioReceived) continue;
                tempQuantityFinished = ratioReceived;
                continue;
            }
            tempQuantityFinished = 0;
        }
        for (StackListEntry<ItemStack> stackListEntry : this.singleFluidSetToReceive.getStacks()) {
            if (this.fluidsReceived.get((FluidStack)stackListEntry.getStack()) != null) {
                ratioReceived = this.fluidsReceived.get((FluidStack)stackListEntry.getStack()).getAmount() / ((FluidStack)stackListEntry.getStack()).getAmount();
                if (tempQuantityFinished <= ratioReceived) continue;
                tempQuantityFinished = ratioReceived;
                continue;
            }
            tempQuantityFinished = 0;
        }
        this.quantityFinished = tempQuantityFinished;
        if (this.quantityFinished == this.totalQuantity) {
            this.state = ProcessingState.PROCESSED;
        }
    }

    @Override
    public void onCalculationFinished() {
        super.onCalculationFinished();
        this.singleItemSetToRequire = this.requirements.getSingleItemRequirementSet(true);
        this.singleFluidSetToRequire = this.requirements.getSingleFluidRequirementSet(true);
    }

    @Override
    public CompoundNBT writeToNbt() {
        CompoundNBT tag = super.writeToNbt();
        tag.func_218657_a(NBT_ITEMS_RECEIVED, (INBT)SerializationUtil.writeItemStackList(this.itemsReceived));
        tag.func_218657_a(NBT_FLUIDS_RECEIVED, (INBT)SerializationUtil.writeFluidStackList(this.fluidsReceived));
        tag.func_218657_a(NBT_SINGLE_ITEM_SET_TO_REQUIRE, (INBT)SerializationUtil.writeItemStackList(this.singleItemSetToRequire));
        tag.func_218657_a(NBT_SINGLE_FLUID_SET_TO_REQUIRE, (INBT)SerializationUtil.writeFluidStackList(this.singleFluidSetToRequire));
        tag.func_74768_a(NBT_STATE, this.state.ordinal());
        return tag;
    }
}

