/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private final INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, ItemStack stack, int preferredSlot, int flags) {
        StackListEntry<ItemStack> stackEntry = this.network.getItemStorageCache().getList().getEntry(stack, 1);
        if (stackEntry != null) {
            this.onExtract(player, stackEntry.getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, int preferredSlot, int flags) {
        ItemStack item = this.network.getItemStorageCache().getList().get(id);
        if (item == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player) || !this.network.canRun()) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.network.getItemStorageTracker().changed((PlayerEntity)player, item.func_77946_l());
        ItemStack took = this.network.extractItem(item, size, Action.SIMULATE);
        if (!took.func_190926_b()) {
            if ((flags & 4) == 4) {
                Optional playerInventory = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).resolve();
                if (playerInventory.isPresent()) {
                    ItemStack remainder;
                    if (preferredSlot != -1 && (remainder = ((IItemHandler)playerInventory.get()).insertItem(preferredSlot, took, true)).func_190916_E() != took.func_190916_E()) {
                        ItemStack inserted = this.network.extractItem(item, size - remainder.func_190916_E(), Action.PERFORM);
                        ((IItemHandler)playerInventory.get()).insertItem(preferredSlot, inserted, false);
                        took.func_190920_e(remainder.func_190916_E());
                    }
                    if (!took.func_190926_b() && ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)playerInventory.get()), (ItemStack)took, (boolean)true).func_190926_b()) {
                        took = this.network.extractItem(item, size, Action.PERFORM);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)playerInventory.get()), (ItemStack)took, (boolean)false);
                    }
                }
            } else {
                took = this.network.extractItem(item, size, Action.PERFORM);
                if (!took.func_190926_b()) {
                    if (single && !held.func_190926_b()) {
                        held.func_190917_f(1);
                    } else {
                        player.field_71071_by.func_70437_b(took);
                    }
                    player.func_71113_k();
                }
            }
            this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage());
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player) || !this.network.canRun()) {
            return stack;
        }
        this.network.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, 1, Action.SIMULATE).func_190926_b()) {
                this.network.insertItem(stack, 1, Action.PERFORM);
                stack.func_190918_g(1);
            }
            remainder = stack;
        } else {
            remainder = this.network.insertItem(stack, stack.func_190916_E(), Action.PERFORM);
        }
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
        return remainder;
    }

    @Override
    public void onInsertHeldItem(ServerPlayerEntity player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player) || !this.network.canRun()) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.network.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        if (single) {
            if (this.network.insertItem(stack, size, Action.SIMULATE).func_190926_b()) {
                this.network.insertItem(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
            }
        } else {
            player.field_71071_by.func_70437_b(this.network.insertItem(stack, size, Action.PERFORM));
        }
        player.func_71113_k();
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                ICalculationResult result = this.network.getCraftingManager().create(stack, quantity);
                if (!result.isOk() && result.getType() != CalculationResultType.MISSING) {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(Collections.singletonList(new ErrorCraftingPreviewElement(result.getType(), result.getRecursedPattern() == null ? ItemStack.field_190927_a : result.getRecursedPattern().getStack())), id, quantity, false));
                } else if (result.isOk() && noPreview) {
                    this.network.getCraftingManager().start(result.getTask());
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
                } else {
                    RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(result.getPreviewElements(), id, quantity, false));
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
        ICalculationResult result;
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null && (result = this.network.getCraftingManager().create(stack, quantity)).isOk()) {
            this.network.getCraftingManager().start(result.getTask());
        }
    }

    @Override
    public void onCraftingCancelRequested(ServerPlayerEntity player, @Nullable UUID id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (PlayerEntity)player)) {
            return;
        }
        this.network.getCraftingManager().cancel(id);
        this.network.getNetworkItemManager().drainEnergy((PlayerEntity)player, id == null ? RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelAllUsage() : RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelUsage());
    }

    @Override
    public void onInventoryScroll(ServerPlayerEntity player, int slot, boolean shift, boolean up) {
        ItemGridHandler.onInventoryScroll(this, player, slot, shift, up, this.network);
    }

    public static void onInventoryScroll(IItemGridHandler gridHandler, ServerPlayerEntity player, int slot, boolean shift, boolean up, @Nullable INetwork network) {
        if (player == null || !(player.field_71070_bA instanceof GridContainer)) {
            return;
        }
        if (network != null && (up && !network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player) || !up && !network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player))) {
            return;
        }
        int flags = 2;
        ItemStack stackInSlot = player.field_71071_by.func_70301_a(slot);
        ItemStack stackOnCursor = player.field_71071_by.func_70445_o();
        if (shift) {
            flags |= 4;
            if (!stackInSlot.func_190926_b()) {
                if (up) {
                    player.field_71071_by.func_70299_a(slot, gridHandler.onInsert(player, stackInSlot, true));
                } else {
                    gridHandler.onExtract(player, stackInSlot, slot, flags);
                }
            }
        } else if (up) {
            if (!stackOnCursor.func_190926_b()) {
                gridHandler.onInsert(player, stackOnCursor, true);
                player.func_71113_k();
            }
        } else if (stackOnCursor.func_190926_b()) {
            gridHandler.onExtract(player, stackInSlot, -1, flags);
        } else {
            gridHandler.onExtract(player, stackOnCursor, -1, flags);
        }
    }

    @Override
    public void onGridScroll(ServerPlayerEntity player, @Nullable UUID id, boolean shift, boolean up) {
        ItemGridHandler.onGridScroll(this, player, id, shift, up, this.network);
    }

    public static void onGridScroll(IItemGridHandler gridHandler, ServerPlayerEntity player, @Nullable UUID id, boolean shift, boolean up, @Nullable INetwork network) {
        if (player == null || !(player.field_71070_bA instanceof GridContainer)) {
            return;
        }
        if (network != null && (up && !network.getSecurityManager().hasPermission(Permission.INSERT, (PlayerEntity)player) || !up && !network.getSecurityManager().hasPermission(Permission.EXTRACT, (PlayerEntity)player))) {
            return;
        }
        IGrid grid = ((GridContainer)player.field_71070_bA).getGrid();
        int flags = 2;
        if (shift && id != null) {
            flags |= 4;
            if (up) {
                IStorageCache cache = grid.getStorageCache();
                if (cache == null || cache.getList().get(id) == null) {
                    return;
                }
                for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    if (!API.instance().getComparer().isEqual(player.field_71071_by.func_70301_a(i), (ItemStack)cache.getList().get(id), 1)) continue;
                    gridHandler.onInsert(player, player.field_71071_by.func_70301_a(i), true);
                    break;
                }
            } else {
                gridHandler.onExtract(player, id, -1, flags);
            }
        } else if (!up && id != null) {
            gridHandler.onExtract(player, id, -1, flags);
        } else if (up && !player.field_71071_by.func_70445_o().func_190926_b()) {
            gridHandler.onInsert(player, player.field_71071_by.func_70445_o(), true);
            player.func_71113_k();
        }
    }
}

