/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PortableItemGridHandler
implements IItemGridHandler {
    private final IPortableGrid portableGrid;
    private final IGrid grid;

    public PortableItemGridHandler(IPortableGrid portableGrid, IGrid grid) {
        this.portableGrid = portableGrid;
        this.grid = grid;
    }

    @Override
    public void onExtract(ServerPlayerEntity player, ItemStack stack, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        if (this.portableGrid.getItemCache().getList().getEntry(stack, 1) != null) {
            this.onExtract(player, this.portableGrid.getItemCache().getList().getEntry(stack, 1).getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(ServerPlayerEntity player, UUID id, int preferredSlot, int flags) {
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        ItemStack item = this.portableGrid.getItemCache().getList().get(id);
        if (item == null) {
            return;
        }
        int itemSize = item.func_190916_E();
        int maxItemSize = item.func_77973_b().getItemStackLimit(item.func_77946_l());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (single ? !held.func_190926_b() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.func_190916_E() + 1 > held.func_77976_d()) : !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.portableGrid.getItemStorageTracker().changed((PlayerEntity)player, item.func_77946_l());
        ItemStack took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.SIMULATE);
        if (!took.func_190926_b()) {
            if ((flags & 4) == 4) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                if (playerInventory != null) {
                    ItemStack remainder;
                    if (preferredSlot != -1 && (remainder = playerInventory.insertItem(preferredSlot, took, true)).func_190916_E() != took.func_190916_E()) {
                        ItemStack inserted = this.portableGrid.getItemStorage().extract(item, size - remainder.func_190916_E(), 1, Action.PERFORM);
                        playerInventory.insertItem(preferredSlot, inserted, false);
                        took.func_190920_e(remainder.func_190916_E());
                    }
                    if (!took.func_190926_b() && ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took, (boolean)true).func_190926_b()) {
                        took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.PERFORM);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)took, (boolean)false);
                    }
                }
            } else {
                took = this.portableGrid.getItemStorage().extract(item, size, 1, Action.PERFORM);
                if (single && !held.func_190926_b()) {
                    held.func_190917_f(1);
                } else {
                    player.field_71071_by.func_70437_b(took);
                }
                player.func_71113_k();
            }
            this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getExtractUsage());
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayerEntity player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return stack;
        }
        this.portableGrid.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, 1, Action.SIMULATE).func_190926_b()) {
                this.portableGrid.getItemStorage().insert(stack, 1, Action.PERFORM);
                stack.func_190918_g(1);
            }
            remainder = stack;
        } else {
            remainder = this.portableGrid.getItemStorage().insert(stack, stack.func_190916_E(), Action.PERFORM);
        }
        this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
        return remainder;
    }

    @Override
    public void onInsertHeldItem(ServerPlayerEntity player, boolean single) {
        if (player.field_71071_by.func_70445_o().func_190926_b() || this.portableGrid.getStorage() == null || !this.grid.isGridActive()) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70445_o();
        int size = single ? 1 : stack.func_190916_E();
        this.portableGrid.getItemStorageTracker().changed((PlayerEntity)player, stack.func_77946_l());
        if (single) {
            if (this.portableGrid.getItemStorage().insert(stack, size, Action.SIMULATE).func_190926_b()) {
                this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM);
                stack.func_190918_g(size);
            }
        } else {
            player.field_71071_by.func_70437_b(this.portableGrid.getItemStorage().insert(stack, size, Action.PERFORM));
        }
        player.func_71113_k();
        this.portableGrid.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getInsertUsage());
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayerEntity player, UUID id, int quantity, boolean noPreview) {
    }

    @Override
    public void onCraftingRequested(ServerPlayerEntity player, UUID id, int quantity) {
    }

    @Override
    public void onCraftingCancelRequested(ServerPlayerEntity player, @Nullable UUID id) {
    }

    @Override
    public void onInventoryScroll(ServerPlayerEntity player, int slot, boolean shift, boolean up) {
        ItemGridHandler.onInventoryScroll(this, player, slot, shift, up, null);
    }

    @Override
    public void onGridScroll(ServerPlayerEntity player, @Nullable UUID id, boolean shift, boolean up) {
        ItemGridHandler.onGridScroll(this, player, id, shift, up, null);
    }
}

