/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.ConstructorTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ConstructorNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "constructor");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_DROP = "Drop";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private final BaseItemHandler itemFilters = new BaseItemHandler(1).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(1).addListener(new NetworkNodeFluidInventoryListener(this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.STACK).addListener(new NetworkNodeInventoryListener(this));
    private int compare = 1;
    private int type = 0;
    private boolean drop = false;

    public ConstructorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getConstructor().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0 && this.world.func_195588_v(this.pos)) {
            if (this.type == 0 && !this.itemFilters.getStackInSlot(0).func_190926_b()) {
                ItemStack stack = this.itemFilters.getStackInSlot(0);
                if (this.drop) {
                    this.extractAndDropItem(stack);
                } else if (stack.func_77973_b() == Items.field_196152_dE) {
                    this.extractAndSpawnFireworks(stack);
                } else if (stack.func_77973_b() instanceof BlockItem) {
                    this.extractAndPlaceBlock(stack);
                }
            } else if (this.type == 1 && !this.fluidFilters.getFluid(0).isEmpty()) {
                this.extractAndPlaceFluid(this.fluidFilters.getFluid(0));
            }
        }
    }

    private void extractAndPlaceFluid(FluidStack stack) {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        if (this.network.extractFluid(stack, 1000, this.compare, Action.SIMULATE).getAmount() < 1000) {
            if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                this.network.getCraftingManager().request((Object)this, stack, 1000);
            }
        } else if (!this.world.func_180495_p(front).func_204520_s().func_206889_d()) {
            FluidUtil.tryPlaceFluid((PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()), (World)this.world, (Hand)Hand.MAIN_HAND, (BlockPos)front, (IFluidHandler)new NetworkFluidHandler(StackUtils.copy(stack, 1000)), (FluidStack)stack);
        }
    }

    private void extractAndPlaceBlock(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.SIMULATE);
        if (!took.func_190926_b()) {
            ConstructorBlockItemUseContext ctx = new ConstructorBlockItemUseContext(this.world, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()), Hand.MAIN_HAND, took, new BlockRayTraceResult(Vector3d.field_186680_a, this.getDirection(), this.pos, false));
            ActionResultType result = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)ctx);
            if (result.func_226246_a_()) {
                this.network.extractItem(stack, 1, Action.PERFORM);
            }
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            ItemStack craft = this.itemFilters.getStackInSlot(0);
            this.network.getCraftingManager().request((Object)this, craft, 1);
        }
    }

    private void extractAndDropItem(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, this.upgrades.getStackInteractCount(), this.compare, Action.PERFORM);
        if (!took.func_190926_b()) {
            DefaultDispenseItemBehavior.func_82486_a((World)this.world, (ItemStack)took, (int)6, (Direction)this.getDirection(), (IPosition)new Position(this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ()));
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
            this.network.getCraftingManager().request((Object)this, stack, 1);
        }
    }

    private void extractAndSpawnFireworks(ItemStack stack) {
        ItemStack took = this.network.extractItem(stack, 1, this.compare, Action.PERFORM);
        if (!took.func_190926_b()) {
            this.world.func_217376_c((Entity)new FireworkRocketEntity(this.world, this.getDispensePositionX(), this.getDispensePositionY(), this.getDispensePositionZ(), took));
        }
    }

    private double getDispensePositionX() {
        return (double)this.pos.func_177958_n() + 0.5 + 0.8 * (double)this.getDirection().func_82601_c();
    }

    private double getDispensePositionY() {
        return (double)this.pos.func_177956_o() + (this.getDirection() == Direction.DOWN ? 0.45 : 0.5) + 0.8 * (double)this.getDirection().func_96559_d();
    }

    private double getDispensePositionZ() {
        return (double)this.pos.func_177952_p() + 0.5 + 0.8 * (double)this.getDirection().func_82599_e();
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_DROP, this.drop);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_DROP)) {
            this.drop = tag.func_74767_n(NBT_DROP);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public boolean isDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? ConstructorTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    private static class ConstructorBlockItemUseContext
    extends BlockItemUseContext {
        public ConstructorBlockItemUseContext(World world, @Nullable PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult rayTraceResult) {
            super(world, player, hand, stack, rayTraceResult);
        }
    }

    private class NetworkFluidHandler
    implements IFluidHandler {
        private final FluidStack resource;

        public NetworkFluidHandler(FluidStack resource) {
            this.resource = resource;
        }

        public int getTanks() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            throw new UnsupportedOperationException();
        }

        public int getTankCapacity(int tank) {
            throw new UnsupportedOperationException();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            throw new UnsupportedOperationException();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return ConstructorNetworkNode.this.network.extractFluid(resource, resource.getAmount(), ConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return ConstructorNetworkNode.this.network.extractFluid(this.resource, this.resource.getAmount(), ConstructorNetworkNode.this.compare, action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
        }
    }
}

