/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.CraftingMonitorBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.craftingmonitor.CraftingMonitorTile;
import com.refinedmods.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CraftingMonitorNetworkNode
extends NetworkNode
implements ICraftingMonitor {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafting_monitor");
    private static final String NBT_TAB_SELECTED = "TabSelected";
    private static final String NBT_TAB_PAGE = "TabPage";
    private Optional<UUID> tabSelected = Optional.empty();
    private int tabPage;

    public CraftingMonitorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCraftingMonitor().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.refinedstorage.crafting_monitor");
    }

    @Override
    public void onCancelled(ServerPlayerEntity player, @Nullable UUID id) {
        if (this.network != null) {
            this.network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return NetworkNodeTile.REDSTONE_MODE;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.network != null ? this.network.getCraftingManager().getTasks() : Collections.emptyList();
    }

    @Override
    @Nullable
    public ICraftingManager getCraftingManager() {
        return this.network != null ? this.network.getCraftingManager() : null;
    }

    @Override
    public boolean isActiveOnClient() {
        BlockState state = this.world.func_180495_p(this.pos);
        if (state.func_177230_c() instanceof CraftingMonitorBlock) {
            return (Boolean)state.func_177229_b((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_74768_a(NBT_TAB_PAGE, this.tabPage);
        this.tabSelected.ifPresent(uuid -> tag.func_186854_a(NBT_TAB_SELECTED, uuid));
        return tag;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_TAB_PAGE)) {
            this.tabPage = tag.func_74762_e(NBT_TAB_PAGE);
        }
        if (tag.func_186855_b(NBT_TAB_SELECTED)) {
            this.tabSelected = Optional.of(tag.func_186857_a(NBT_TAB_SELECTED));
        }
    }

    public void setTabSelected(Optional<UUID> tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int tabPage) {
        this.tabPage = tabPage;
    }

    @Override
    public void onClosed(PlayerEntity player) {
    }

    @Override
    public Optional<UUID> getTabSelected() {
        return this.world.field_72995_K ? CraftingMonitorTile.TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.world.field_72995_K ? CraftingMonitorTile.TAB_PAGE.getValue() : this.tabPage;
    }

    @Override
    public void onTabSelectionChanged(Optional<UUID> tab) {
        TileDataManager.setParameter(CraftingMonitorTile.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0) {
            TileDataManager.setParameter(CraftingMonitorTile.TAB_PAGE, page);
        }
    }

    @Override
    public int getSlotId() {
        return -1;
    }
}

