/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk.factory;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.apiimpl.storage.ItemStorageType;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.ItemStorageDisk;
import com.refinedmods.refinedstorage.item.StorageDiskItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class ItemStorageDiskFactory
implements IStorageDiskFactory<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "item");

    @Override
    public IStorageDisk<ItemStack> createFromNbt(ServerWorld world, CompoundNBT tag) {
        ItemStorageDisk disk = new ItemStorageDisk(world, tag.func_74762_e("Capacity"), tag.func_74764_b("Owner") ? tag.func_186857_a("Owner") : null);
        ListNBT list = tag.func_150295_c("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = StackUtils.deserializeStackFromNbt(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            disk.getRawStacks().put((Object)stack.func_77973_b(), (Object)stack);
        }
        disk.updateItemCount();
        return disk;
    }

    @Override
    public ItemStack createDiskItem(IStorageDisk<ItemStack> disk, UUID id) {
        StorageDiskItem item;
        switch (disk.getCapacity()) {
            case 1000: {
                item = (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.ONE_K).get();
                break;
            }
            case 4000: {
                item = (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.FOUR_K).get();
                break;
            }
            case 16000: {
                item = (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.SIXTEEN_K).get();
                break;
            }
            case 64000: {
                item = (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.SIXTY_FOUR_K).get();
                break;
            }
            default: {
                item = (StorageDiskItem)RSItems.ITEM_STORAGE_DISKS.get((Object)ItemStorageType.CREATIVE).get();
            }
        }
        ItemStack stack = new ItemStack((IItemProvider)item);
        item.setId(stack, id);
        return stack;
    }

    @Override
    public IStorageDisk<ItemStack> create(ServerWorld world, int capacity, @Nullable UUID owner) {
        return new ItemStorageDisk(world, capacity, owner);
    }
}

