/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.tracker;

import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageTracker
implements IStorageTracker<FluidStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private final Map<Key, StorageTrackerEntry> changes = new HashMap<Key, StorageTrackerEntry>();
    private final Runnable listener;

    public FluidStorageTracker(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(PlayerEntity player, FluidStack stack) {
        this.changes.put(new Key(stack), new StorageTrackerEntry(System.currentTimeMillis(), player.func_200200_C_().getString()));
        this.listener.run();
    }

    @Override
    public StorageTrackerEntry get(FluidStack stack) {
        return this.changes.get(new Key(stack));
    }

    public void readFromNbt(ListNBT list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l(NBT_STACK));
            if (stack.isEmpty()) continue;
            this.changes.put(new Key(stack), new StorageTrackerEntry(tag.func_74763_f(NBT_TIME), tag.func_74779_i(NBT_NAME)));
        }
    }

    public ListNBT serializeNbt() {
        ListNBT list = new ListNBT();
        for (Map.Entry<Key, StorageTrackerEntry> entry : this.changes.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74772_a(NBT_TIME, entry.getValue().getTime());
            tag.func_74778_a(NBT_NAME, entry.getValue().getName());
            tag.func_218657_a(NBT_STACK, (INBT)entry.getKey().stack.writeToNBT(new CompoundNBT()));
            list.add((Object)tag);
        }
        return list;
    }

    private static class Key {
        private final FluidStack stack;

        public Key(FluidStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object other) {
            return other instanceof Key && API.instance().getComparer().isEqual(this.stack, ((Key)other).stack, 1);
        }

        public int hashCode() {
            return API.instance().getFluidStackHashCode(this.stack);
        }
    }
}

