/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.block.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class NetworkCardItem
extends Item {
    private static final String NBT_RECEIVER_X = "ReceiverX";
    private static final String NBT_RECEIVER_Y = "ReceiverY";
    private static final String NBT_RECEIVER_Z = "ReceiverZ";
    private static final String NBT_DIMENSION = "Dimension";

    public NetworkCardItem() {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        Block block = ctx.func_195991_k().func_180495_p(ctx.func_195995_a()).func_177230_c();
        if (block instanceof NetworkReceiverBlock) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(NBT_RECEIVER_X, ctx.func_195995_a().func_177958_n());
            tag.func_74768_a(NBT_RECEIVER_Y, ctx.func_195995_a().func_177956_o());
            tag.func_74768_a(NBT_RECEIVER_Z, ctx.func_195995_a().func_177952_p());
            tag.func_74778_a(NBT_DIMENSION, ctx.func_195991_k().func_234923_W_().func_240901_a_().toString());
            ctx.func_195999_j().func_184586_b(ctx.func_221531_n()).func_77982_d(tag);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        BlockPos pos = NetworkCardItem.getReceiver(stack);
        RegistryKey<World> type = NetworkCardItem.getDimension(stack);
        if (pos != null && type != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.network_card.tooltip", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), type.func_240901_a_().toString()}).func_230530_a_(Styles.GRAY));
        }
    }

    @Nullable
    public static BlockPos getReceiver(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_RECEIVER_X) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Y) && stack.func_77978_p().func_74764_b(NBT_RECEIVER_Z)) {
            return new BlockPos(stack.func_77978_p().func_74762_e(NBT_RECEIVER_X), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Y), stack.func_77978_p().func_74762_e(NBT_RECEIVER_Z));
        }
        return null;
    }

    @Nullable
    public static RegistryKey<World> getDimension(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_DIMENSION)) {
            ResourceLocation name = ResourceLocation.func_208304_a((String)stack.func_77978_p().func_74779_i(NBT_DIMENSION));
            if (name == null) {
                return null;
            }
            return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)name);
        }
        return null;
    }
}

