/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.container.GridContainer;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridItemGridScrollMessage {
    private final UUID id;
    private final boolean shift;
    private final boolean up;

    public GridItemGridScrollMessage(@Nullable UUID id, boolean shift, boolean up) {
        this.id = id;
        this.shift = shift;
        this.up = up;
    }

    public static GridItemGridScrollMessage decode(PacketBuffer buf) {
        return new GridItemGridScrollMessage(buf.readBoolean() ? buf.func_179253_g() : null, buf.readBoolean(), buf.readBoolean());
    }

    public static void encode(GridItemGridScrollMessage message, PacketBuffer buf) {
        boolean hasId = message.id != null;
        buf.writeBoolean(hasId);
        if (hasId) {
            buf.func_179252_a(message.id);
        }
        buf.writeBoolean(message.shift);
        buf.writeBoolean(message.up);
    }

    public static void handle(GridItemGridScrollMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.field_71070_bA instanceof GridContainer && ((GridContainer)player.field_71070_bA).getGrid().getItemHandler() != null) {
                ((GridContainer)player.field_71070_bA).getGrid().getItemHandler().onGridScroll(player, message.id, message.shift, message.up);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

