/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.block.PortableGridBlock;
import com.refinedmods.refinedstorage.render.model.DelegateBakedModel;
import com.refinedmods.refinedstorage.render.model.PortableGridItemBakedModel;
import com.refinedmods.refinedstorage.render.model.QuadTransformer;
import com.refinedmods.refinedstorage.tile.grid.portable.PortableGrid;
import com.refinedmods.refinedstorage.tile.grid.portable.PortableGridDiskState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class PortableGridBakedModel
extends DelegateBakedModel {
    private final IBakedModel baseConnected;
    private final IBakedModel baseDisconnected;
    private final IBakedModel disk;
    private final IBakedModel diskNearCapacity;
    private final IBakedModel diskFull;
    private final IBakedModel diskDisconnected;
    private final CustomItemOverrideList itemOverrideList = new CustomItemOverrideList();
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(@Nonnull CacheKey key) {
            Direction direction = (Direction)key.state.func_177229_b((Property)((PortableGridBlock)RSBlocks.PORTABLE_GRID.get()).getDirection().getProperty());
            boolean active = (Boolean)key.state.func_177229_b((Property)PortableGridBlock.ACTIVE);
            PortableGridDiskState diskState = (PortableGridDiskState)((Object)key.state.func_177229_b(PortableGridBlock.DISK_STATE));
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(QuadTransformer.getTransformedQuads(active ? PortableGridBakedModel.this.baseConnected : PortableGridBakedModel.this.baseDisconnected, direction, null, key.state, key.random, key.side));
            IBakedModel diskModel = PortableGridBakedModel.this.getDiskModel(diskState);
            if (diskModel != null) {
                quads.addAll(QuadTransformer.getTransformedQuads(diskModel, direction, null, key.state, key.random, key.side));
            }
            return quads;
        }
    });

    public PortableGridBakedModel(IBakedModel baseConnected, IBakedModel baseDisconnected, IBakedModel disk, IBakedModel diskNearCapacity, IBakedModel diskFull, IBakedModel diskDisconnected) {
        super(baseConnected);
        this.baseConnected = baseConnected;
        this.baseDisconnected = baseDisconnected;
        this.disk = disk;
        this.diskNearCapacity = diskNearCapacity;
        this.diskFull = diskFull;
        this.diskDisconnected = diskDisconnected;
    }

    @Nullable
    private IBakedModel getDiskModel(PortableGridDiskState state) {
        switch (state) {
            case NORMAL: {
                return this.disk;
            }
            case NEAR_CAPACITY: {
                return this.diskNearCapacity;
            }
            case FULL: {
                return this.diskFull;
            }
            case DISCONNECTED: {
                return this.diskDisconnected;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (state != null) {
            return (List)this.cache.getUnchecked((Object)new CacheKey(state, side, rand));
        }
        return super.func_200117_a(state, side, rand);
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final Random random;

        public CacheKey(BlockState state, Direction side, Random random) {
            this.state = state;
            this.side = side;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.state.equals(cacheKey.state) && this.side == cacheKey.side && this.random.equals(cacheKey.random);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.side, this.random);
        }
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
        }

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            PortableGrid portableGrid = new PortableGrid(null, stack, -1);
            if (portableGrid.isGridActive()) {
                return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseConnected, PortableGridBakedModel.this.getDiskModel(portableGrid.getDiskState()));
            }
            return new PortableGridItemBakedModel(PortableGridBakedModel.this.baseDisconnected, PortableGridBakedModel.this.getDiskModel(portableGrid.getDiskState()));
        }
    }
}

