/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.integration.craftingtweaks.CraftingTweaksIntegration;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.FluidAmountScreen;
import com.refinedmods.refinedstorage.screen.ItemAmountScreen;
import com.refinedmods.refinedstorage.screen.grid.AlternativesScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.SideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public abstract class BaseScreen<T extends Container>
extends ContainerScreen<T> {
    public static final int Z_LEVEL_ITEMS = 100;
    public static final int Z_LEVEL_TOOLTIPS = 500;
    public static final int Z_LEVEL_QTY = 300;
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();
    private static final Map<Class, Queue<Consumer>> ACTIONS = new HashMap<Class, Queue<Consumer>>();
    private static final ITextComponent ALTERNATIVES_TEXT = new TranslationTextComponent("gui.refinedstorage.alternatives");
    private final List<SideButton> sideButtons = new ArrayList<SideButton>();
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private int sideButtonY;

    protected BaseScreen(T container, int xSize, int ySize, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.field_146999_f = xSize;
        this.field_147000_g = ySize;
    }

    private void runActions() {
        this.runActions(((Object)((Object)this)).getClass());
        this.runActions(ContainerScreen.class);
    }

    private void runActions(Class clazz) {
        Queue<Consumer> queue = ACTIONS.get(clazz);
        if (queue != null && !queue.isEmpty()) {
            Consumer callback;
            while ((callback = queue.poll()) != null) {
                callback.accept(this);
            }
        }
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.onPreInit();
        super.func_231160_c_();
        if (CraftingTweaksIntegration.isLoaded()) {
            this.field_230710_m_.removeIf(b -> !CraftingTweaksIntegration.isCraftingTweaksClass(b.getClass()));
            this.field_230705_e_.removeIf(c -> !CraftingTweaksIntegration.isCraftingTweaksClass(c.getClass()));
        } else {
            this.field_230710_m_.clear();
            this.field_230705_e_.clear();
        }
        this.sideButtonY = 6;
        this.sideButtons.clear();
        this.onPostInit(this.field_147003_i, this.field_147009_r);
        this.runActions();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.runActions();
        this.tick(this.field_147003_i, this.field_147009_r);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float renderPartialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground(matrixStack, this.field_147003_i, this.field_147009_r, mouseX, mouseY);
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!slot.func_111238_b() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty()) continue;
            FluidRenderer.INSTANCE.render(matrixStack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, stack);
            if (!((FluidFilterSlot)slot).isSizeAllowed()) continue;
            this.renderQuantity(matrixStack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, API.instance().getQuantityFormatter().formatInBucketForm(stack.getAmount()), RenderSettings.INSTANCE.getSecondaryColor());
            GL11.glDisable((int)2896);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderForeground(matrixStack, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        for (Widget button : this.field_230710_m_) {
            if (!(button instanceof SideButton) || !button.func_230449_g_()) continue;
            this.renderTooltip(matrixStack, mouseX, mouseY, ((SideButton)button).getTooltip());
        }
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            FluidStack stack;
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!slot.func_111238_b() || !(slot instanceof FluidFilterSlot) || (stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex())).isEmpty() || !RenderUtils.inBounds(slot.field_75223_e, slot.field_75221_f, 17, 17, mouseX, mouseY)) continue;
            this.renderTooltip(matrixStack, mouseX, mouseY, stack.getDisplayName().getString());
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int mouseButton, ClickType type) {
        boolean valid;
        boolean bl = valid = type != ClickType.QUICK_MOVE && this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
        if (valid && slot instanceof FilterSlot && slot.func_111238_b() && ((FilterSlot)slot).isSizeAllowed()) {
            if (!slot.func_75211_c().func_190926_b()) {
                if (((FilterSlot)slot).isAlternativesAllowed() && BaseScreen.func_231172_r_()) {
                    this.field_230706_i_.func_147108_a((Screen)new AlternativesScreen((Screen)this, (PlayerEntity)this.field_230706_i_.field_71439_g, ALTERNATIVES_TEXT, slot.func_75211_c(), slot.getSlotIndex()));
                } else {
                    this.field_230706_i_.func_147108_a((Screen)new ItemAmountScreen(this, (PlayerEntity)this.field_230706_i_.field_71439_g, slot.field_75222_d, slot.func_75211_c(), slot.func_75219_a(), ((FilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)parent, (PlayerEntity)this.field_230706_i_.field_71439_g, ALTERNATIVES_TEXT, slot.func_75211_c(), slot.getSlotIndex()) : null));
                }
            }
        } else if (valid && slot instanceof FluidFilterSlot && slot.func_111238_b() && ((FluidFilterSlot)slot).isSizeAllowed()) {
            FluidStack stack = ((FluidFilterSlot)slot).getFluidInventory().getFluid(slot.getSlotIndex());
            if (!stack.isEmpty()) {
                if (((FluidFilterSlot)slot).isAlternativesAllowed() && BaseScreen.func_231172_r_()) {
                    this.field_230706_i_.func_147108_a((Screen)new AlternativesScreen((Screen)this, (PlayerEntity)this.field_230706_i_.field_71439_g, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()));
                } else {
                    this.field_230706_i_.func_147108_a((Screen)new FluidAmountScreen(this, (PlayerEntity)this.field_230706_i_.field_71439_g, slot.field_75222_d, stack, ((FluidFilterSlot)slot).getFluidInventory().getMaxAmount(), ((FluidFilterSlot)slot).isAlternativesAllowed() ? parent -> new AlternativesScreen((Screen)this, (PlayerEntity)this.field_230706_i_.field_71439_g, ALTERNATIVES_TEXT, stack, slot.getSlotIndex()) : null));
                }
            } else {
                super.func_184098_a(slot, slotId, mouseButton, type);
            }
        } else {
            super.func_184098_a(slot, slotId, mouseButton, type);
        }
    }

    public CheckboxWidget addCheckBox(int x, int y, ITextComponent text, boolean checked, Consumer<CheckboxButton> onPress) {
        CheckboxWidget checkBox = new CheckboxWidget(x, y, text, checked, onPress);
        this.func_230480_a_((Widget)checkBox);
        return checkBox;
    }

    public Button addButton(int x, int y, int w, int h, ITextComponent text, boolean enabled, boolean visible, Button.IPressable onPress) {
        Button button = new Button(x, y, w, h, text, onPress);
        button.field_230693_o_ = enabled;
        button.field_230694_p_ = visible;
        this.func_230480_a_((Widget)button);
        return button;
    }

    public void addSideButton(SideButton button) {
        button.field_230690_l_ = this.field_147003_i - button.func_230998_h_() - 2;
        button.field_230691_m_ = this.field_147009_r + this.sideButtonY;
        this.sideButtonY += button.getHeight() + 2;
        this.sideButtons.add(button);
        this.func_230480_a_((Widget)button);
    }

    public List<SideButton> getSideButtons() {
        return this.sideButtons;
    }

    public void bindTexture(String namespace, String filenameInTexturesFolder) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE_CACHE.computeIfAbsent(namespace + ":" + filenameInTexturesFolder, newId -> new ResourceLocation(namespace, "textures/" + filenameInTexturesFolder)));
    }

    public void renderItem(MatrixStack matrixStack, int x, int y, ItemStack stack) {
        this.renderItem(matrixStack, x, y, stack, false, null, 0);
    }

    public void renderItem(MatrixStack matrixStack, int x, int y, ItemStack stack, boolean overlay, @Nullable String text, int textColor) {
        try {
            this.func_230926_e_(100);
            this.field_230707_j_.field_77023_b = 100.0f;
            this.field_230707_j_.func_175042_a(stack, x, y);
            if (overlay) {
                this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, x, y, "");
            }
            this.func_230926_e_(0);
            this.field_230707_j_.field_77023_b = 0.0f;
            if (text != null) {
                this.renderQuantity(matrixStack, x, y, text, textColor);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Couldn't render stack: {}", (Object)stack.func_77973_b().getRegistryName());
        }
    }

    public void renderQuantity(MatrixStack matrixStack, int x, int y, String qty, int color) {
        boolean large = this.field_230706_i_.func_211821_e() || RS.CLIENT_CONFIG.getGrid().getLargeFont();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 300.0);
        if (!large) {
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        }
        this.field_230712_o_.func_238405_a_(matrixStack, qty, (float)((large ? 16 : 30) - this.field_230712_o_.func_78256_a(qty)), large ? 8.0f : 22.0f, color);
        matrixStack.func_227865_b_();
    }

    public void renderString(MatrixStack matrixStack, int x, int y, String message) {
        this.renderString(matrixStack, x, y, message, RenderSettings.INSTANCE.getPrimaryColor());
    }

    public void renderString(MatrixStack matrixStack, int x, int y, String message, int color) {
        this.field_230712_o_.func_238421_b_(matrixStack, message, (float)x, (float)y, color);
    }

    public void renderTooltip(MatrixStack matrixStack, int x, int y, String lines) {
        this.renderTooltip(matrixStack, ItemStack.field_190927_a, x, y, lines);
    }

    public void renderTooltip(MatrixStack matrixStack, @Nonnull ItemStack stack, int x, int y, String lines) {
        this.renderTooltip(matrixStack, stack, x, y, Arrays.stream(lines.split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
    }

    public void renderTooltip(MatrixStack matrixStack, @Nonnull ItemStack stack, int x, int y, List<ITextComponent> lines) {
        GuiUtils.drawHoveringText((ItemStack)stack, (MatrixStack)matrixStack, lines, (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
    }

    protected void onPreInit() {
    }

    public static boolean isKeyDown(KeyBinding keybinding) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keybinding.getKey().func_197937_c()) && keybinding.getKeyConflictContext().isActive() && keybinding.getKeyModifier().isActive(keybinding.getKeyConflictContext());
    }

    public abstract void onPostInit(int var1, int var2);

    public abstract void tick(int var1, int var2);

    public abstract void renderBackground(MatrixStack var1, int var2, int var3, int var4, int var5);

    public abstract void renderForeground(MatrixStack var1, int var2, int var3);

    public static <T> void executeLater(Class<T> clazz, Consumer<T> callback) {
        ACTIONS.computeIfAbsent(clazz, key -> new ArrayDeque()).add(callback);
    }

    public static void executeLater(Consumer<ContainerScreen> callback) {
        BaseScreen.executeLater(ContainerScreen.class, callback);
    }
}

