/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.stack;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.RenderSettings;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemGridStack
implements IGridStack {
    private static final String ERROR_PLACEHOLDER = "<Error>";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private UUID id;
    @Nullable
    private UUID otherId;
    private final ItemStack stack;
    private boolean craftable;
    @Nullable
    private StorageTrackerEntry entry;
    private boolean zeroed;
    private Set<String> cachedTags;
    private String cachedName;
    private String cachedModId;
    private String cachedModName;
    private List<ITextComponent> cachedTooltip;

    public ItemGridStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemGridStack(UUID id, @Nullable UUID otherId, ItemStack stack, boolean craftable, StorageTrackerEntry entry) {
        this.id = id;
        this.otherId = otherId;
        this.stack = stack;
        this.craftable = craftable;
        this.entry = entry;
    }

    public void setZeroed(boolean zeroed) {
        this.zeroed = zeroed;
    }

    @Nullable
    static String getModNameByModId(String modId) {
        Optional modContainer = ModList.get().getModContainerById(modId);
        return modContainer.map(container -> container.getModInfo().getDisplayName()).orElse(null);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    @Nullable
    public UUID getOtherId() {
        return this.otherId;
    }

    @Override
    public void updateOtherId(@Nullable UUID otherId) {
        this.otherId = otherId;
    }

    @Override
    public String getName() {
        if (this.cachedName == null) {
            try {
                this.cachedName = this.stack.func_200301_q().getString();
            }
            catch (Throwable t) {
                this.logger.warn("Could not retrieve item name of {}", (Object)this.stack.func_77973_b().getRegistryName());
                this.cachedName = ERROR_PLACEHOLDER;
            }
        }
        return this.cachedName;
    }

    @Override
    public String getModId() {
        if (this.cachedModId == null) {
            this.cachedModId = this.stack.func_77973_b().getCreatorModId(this.stack);
            if (this.cachedModId == null) {
                this.cachedModId = ERROR_PLACEHOLDER;
            }
            this.cachedModId = this.cachedModId.toLowerCase().replace(" ", "");
        }
        return this.cachedModId;
    }

    @Override
    public String getModName() {
        if (this.cachedModName == null) {
            this.cachedModName = ItemGridStack.getModNameByModId(this.getModId());
            if (this.cachedModName == null) {
                this.cachedModName = ERROR_PLACEHOLDER;
            }
        }
        return this.cachedModName;
    }

    @Override
    public Set<String> getTags() {
        if (this.cachedTags == null) {
            this.cachedTags = new HashSet<String>();
            for (ResourceLocation owningTag : ItemTags.func_199903_a().func_199913_a((Object)this.stack.func_77973_b())) {
                this.cachedTags.add(owningTag.func_110623_a());
            }
        }
        return this.cachedTags;
    }

    @Override
    public List<ITextComponent> getTooltip(boolean bypassCache) {
        if (bypassCache || this.cachedTooltip == null) {
            List<ITextComponent> tooltip;
            try {
                tooltip = RenderUtils.getTooltipFromItem(this.stack);
            }
            catch (Throwable t) {
                this.logger.warn("Could not retrieve item tooltip of {}", (Object)this.stack.func_77973_b().getRegistryName());
                tooltip = new ArrayList<ITextComponent>();
                tooltip.add((ITextComponent)new StringTextComponent(ERROR_PLACEHOLDER));
            }
            if (bypassCache) {
                return tooltip;
            }
            this.cachedTooltip = tooltip;
        }
        return this.cachedTooltip;
    }

    @Override
    public int getQuantity() {
        return this.isCraftable() || this.zeroed ? 0 : this.stack.func_190916_E();
    }

    @Override
    public void setQuantity(int amount) {
        if (amount <= 0) {
            this.setZeroed(true);
        } else {
            this.stack.func_190920_e(amount);
        }
    }

    @Override
    public String getFormattedFullQuantity() {
        if (this.zeroed) {
            return "0";
        }
        return API.instance().getQuantityFormatter().format(this.getQuantity());
    }

    @Override
    public void draw(MatrixStack matrixStack, BaseScreen<?> screen, int x, int y) {
        String text = null;
        int color = RenderSettings.INSTANCE.getSecondaryColor();
        if (this.zeroed) {
            text = "0";
            color = 0xFF5555;
        } else if (this.craftable) {
            text = I18n.func_135052_a((String)"gui.refinedstorage.grid.craft", (Object[])new Object[0]);
        } else if (this.stack.func_190916_E() > 1) {
            text = API.instance().getQuantityFormatter().formatWithUnits(this.getQuantity());
        }
        screen.renderItem(matrixStack, x, y, this.stack, true, text, color);
    }

    @Override
    public Object getIngredient() {
        return this.getStack();
    }

    @Override
    @Nullable
    public StorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable StorageTrackerEntry entry) {
        this.entry = entry;
    }
}

