/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.apiimpl.network.node.FluidInterfaceNetworkNode;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidInterfaceTile
extends NetworkNodeTile<FluidInterfaceNetworkNode> {
    public static final TileDataParameter<FluidStack, FluidInterfaceTile> TANK_IN = new TileDataParameter<FluidStack, FluidInterfaceTile>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankIn().getFluid());
    public static final TileDataParameter<FluidStack, FluidInterfaceTile> TANK_OUT = new TileDataParameter<FluidStack, FluidInterfaceTile>(RSSerializers.FLUID_STACK_SERIALIZER, FluidStack.EMPTY, t -> ((FluidInterfaceNetworkNode)t.getNode()).getTankOut().getFluid());
    private final LazyOptional<IFluidHandler> tankCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getTank());
    private final LazyOptional<IItemHandler> inCapability = LazyOptional.of(() -> ((FluidInterfaceNetworkNode)this.getNode()).getIn());

    public FluidInterfaceTile() {
        super(RSTiles.FLUID_INTERFACE);
        this.dataManager.addParameter(TANK_IN);
        this.dataManager.addParameter(TANK_OUT);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inCapability.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public FluidInterfaceNetworkNode createNode(World world, BlockPos pos) {
        return new FluidInterfaceNetworkNode(world, pos);
    }
}

