/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile.data;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.network.tiledata.TileDataParameterMessage;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.entity.player.ServerPlayerEntity;

public class TileDataWatcher {
    private boolean sentInitial;
    private final ServerPlayerEntity player;
    private final TileDataManager manager;
    private Object[] cache;

    public TileDataWatcher(ServerPlayerEntity player, TileDataManager manager) {
        this.player = player;
        this.manager = manager;
        if (manager != null) {
            this.manager.addWatcher(this);
            this.cache = new Object[manager.getWatchedParameters().size()];
        }
    }

    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public void onClosed() {
        this.manager.removeWatcher(this);
    }

    public void detectAndSendChanges() {
        if (!this.sentInitial) {
            this.manager.getParameters().forEach(p -> this.sendParameter(true, (TileDataParameter)p));
            this.sentInitial = true;
        } else {
            for (int i = 0; i < this.manager.getWatchedParameters().size(); ++i) {
                Object cached;
                TileDataParameter parameter = this.manager.getWatchedParameters().get(i);
                Object real = parameter.getValueProducer().apply(this.manager.getTile());
                if (real.equals(cached = this.cache[i])) continue;
                this.cache[i] = real;
                if (cached == null) continue;
                this.sendParameter(false, parameter);
            }
        }
    }

    public void sendParameter(boolean initial, TileDataParameter parameter) {
        RS.NETWORK_HANDLER.sendTo(this.player, new TileDataParameterMessage(this.manager.getTile(), parameter, initial));
    }
}

