/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.item.blockitem.ColoredBlockItem;
import com.refinedmods.refinedstorage.util.BlockUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ColorMap<T extends IForgeRegistryEntry<? super T>> {
    public static final DyeColor DEFAULT_COLOR = DyeColor.LIGHT_BLUE;
    private final Map<DyeColor, RegistryObject<T>> map = new EnumMap<DyeColor, RegistryObject<T>>(DyeColor.class);
    private DeferredRegister<Item> itemRegister;
    private DeferredRegister<Block> blockRegister;
    private List<Runnable> lateRegistration;

    public ColorMap(DeferredRegister<Block> blockRegister) {
        this.blockRegister = blockRegister;
    }

    public ColorMap(DeferredRegister<Item> itemRegister, List<Runnable> lateRegistration) {
        this.itemRegister = itemRegister;
        this.lateRegistration = lateRegistration;
    }

    public RegistryObject<T> get(DyeColor color) {
        return this.map.get(color);
    }

    public Collection<RegistryObject<T>> values() {
        return this.map.values();
    }

    public void put(DyeColor color, RegistryObject<T> object) {
        this.map.put(color, object);
    }

    public void forEach(BiConsumer<DyeColor, RegistryObject<T>> consumer) {
        this.map.forEach(consumer);
    }

    public Block[] getBlocks() {
        return (Block[])this.map.values().stream().map(RegistryObject::get).toArray(Block[]::new);
    }

    public <S extends Block> void registerBlocks(String name, Supplier<S> blockFactory) {
        for (DyeColor color : DyeColor.values()) {
            String prefix = color != DEFAULT_COLOR ? color + "_" : "";
            RegistryObject block = this.blockRegister.register(prefix + name, blockFactory);
            this.map.put(color, block);
            RSBlocks.COLORED_BLOCKS.add((RegistryObject<? extends Block>)block);
        }
    }

    public <S extends BaseBlock> void registerItemsFromBlocks(ColorMap<S> blockMap) {
        RegistryObject originalBlock = blockMap.get(DEFAULT_COLOR);
        this.map.put(DEFAULT_COLOR, this.registerBlockItemFor(originalBlock, DEFAULT_COLOR, originalBlock));
        this.lateRegistration.add(() -> blockMap.forEach((color, block) -> {
            if (color != DEFAULT_COLOR) {
                this.map.put((DyeColor)color, this.registerBlockItemFor((RegistryObject)block, (DyeColor)color, originalBlock));
            }
        }));
        RSItems.COLORED_ITEM_TAGS.put((Tags.IOptionalNamedTag<Item>)ItemTags.createOptional((ResourceLocation)new ResourceLocation("refinedstorage", blockMap.get(DEFAULT_COLOR).getId().func_110623_a())), this);
    }

    private <S extends BaseBlock> RegistryObject<T> registerBlockItemFor(RegistryObject<S> block, DyeColor color, RegistryObject<S> translationBlock) {
        return this.itemRegister.register(block.getId().func_110623_a(), () -> new ColoredBlockItem((BaseBlock)block.get(), new Item.Properties().func_200916_a(RS.MAIN_GROUP), color, BlockUtils.getBlockTranslation((Block)translationBlock.get())));
    }

    public <S extends BaseBlock> ActionResultType changeBlockColor(BlockState state, ItemStack heldItem, World world, BlockPos pos, PlayerEntity player) {
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color == null || state.func_177230_c().equals(this.map.get(color).get())) {
            return ActionResultType.PASS;
        }
        return this.setBlockState(this.getNewState(this.map.get(color), state), heldItem, world, pos, player);
    }

    private <S extends BaseBlock> BlockState getNewState(RegistryObject<S> block, BlockState state) {
        if (((BaseBlock)block.get()).getDirection() == BlockDirection.NONE) {
            return (BlockState)((BaseBlock)block.get()).func_176223_P().func_206870_a((Property)NetworkNodeBlock.CONNECTED, state.func_177229_b((Property)NetworkNodeBlock.CONNECTED));
        }
        return (BlockState)((BlockState)((BaseBlock)block.get()).func_176223_P().func_206870_a((Property)NetworkNodeBlock.CONNECTED, state.func_177229_b((Property)NetworkNodeBlock.CONNECTED))).func_206870_a((Property)((BaseBlock)block.get()).getDirection().getProperty(), state.func_177229_b((Property)((BaseBlock)block.get()).getDirection().getProperty()));
    }

    public ActionResultType setBlockState(BlockState newState, ItemStack heldItem, World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            world.func_175656_a(pos, newState);
            if (((ServerPlayerEntity)player).field_71134_c.func_73081_b() != GameType.CREATIVE) {
                heldItem.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }
}

