/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity.ai;

import baguchan.earthmobsmod.entity.MooBloomEntity;
import baguchan.earthmobsmod.init.EarthBlocks;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EatGrassOrBloomGoal
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    private static final Predicate<BlockState> IS_BUTTERCUP = BlockStateMatcher.func_177638_a((Block)EarthBlocks.BUTTERCUP);
    private final MooBloomEntity grassEaterEntity;
    private final World entityWorld;
    private int eatingGrassTimer;

    public EatGrassOrBloomGoal(MooBloomEntity grassEaterEntityIn) {
        this.grassEaterEntity = grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        BlockPos blockpos = new BlockPos((Vector3i)this.grassEaterEntity.func_233580_cy_());
        if (this.grassEaterEntity.getEatDelayTimer() <= 0) {
            if (IS_BUTTERCUP.test(this.entityWorld.func_180495_p(blockpos))) {
                return true;
            }
            if (this.grassEaterEntity.func_70681_au().nextInt(this.grassEaterEntity.func_70631_g_() ? 100 : 1000) != 0) {
                return false;
            }
            return IS_BUTTERCUP.test(this.entityWorld.func_180495_p(blockpos));
        }
        return false;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        BlockPos blockpos;
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4 && IS_BUTTERCUP.test(this.entityWorld.func_180495_p(blockpos = new BlockPos((Vector3i)this.grassEaterEntity.func_233580_cy_())))) {
            if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.grassEaterEntity)) {
                this.entityWorld.func_175655_b(blockpos, false);
            }
            this.grassEaterEntity.func_195064_c(new EffectInstance(Effects.field_76428_l, 160, 0));
            this.grassEaterEntity.func_70615_aA();
            this.grassEaterEntity.setEatDelayTimer(200);
        }
    }
}

