/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor.mixins;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAExtraStuff;

@Mixin(value={AbstractIllagerEntity.class})
public abstract class AbstractIllagerEntityMixin
extends AbstractRaiderEntity {
    protected AbstractIllagerEntityMixin(EntityType<? extends AbstractRaiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (IWAConfig.IllagerArmor.booleanValue() && !IWAConfig.ArmorBlackList.contains(this.func_70022_Q())) {
            if (reason == SpawnReason.EVENT) {
                this.giveArmorOnRaids();
            } else {
                this.giveArmorNaturally(difficultyIn);
            }
            super.func_180483_b(difficultyIn);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void giveArmorOnRaids() {
        float f = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
        int illagerWaves = this.func_213663_ek().func_221315_l();
        int armorChance = illagerWaves > 4 ? 4 : illagerWaves;
        float waveChances = IWAExtraStuff.getWaveArmorChances(illagerWaves);
        if (this.field_70146_Z.nextFloat() < waveChances) {
            if (this.field_70146_Z.nextFloat() < 0.045f) {
                ++armorChance;
            }
            boolean flag = true;
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                Item item;
                if (equipmentslottype.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(equipmentslottype);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = AbstractIllagerEntityMixin.func_184636_a((EquipmentSlotType)equipmentslottype, (int)armorChance)) == null) continue;
                this.func_184201_a(equipmentslottype, new ItemStack((IItemProvider)item));
            }
        }
    }

    protected void giveArmorNaturally(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.15f * difficulty.func_180170_c()) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                Item item;
                if (equipmentslottype.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(equipmentslottype);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || (item = AbstractIllagerEntityMixin.func_184636_a((EquipmentSlotType)equipmentslottype, (int)i)) == null) continue;
                this.func_184201_a(equipmentslottype, new ItemStack((IItemProvider)item));
            }
        }
    }
}

