/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.customslots;

import com.google.common.collect.ImmutableSet;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotItemCapability;
import dev.gigaherz.toolbelt.customslots.IExtensionContainer;
import dev.gigaherz.toolbelt.customslots.IExtensionSlotItem;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public interface IExtensionSlot {
    @Nonnull
    public IExtensionContainer getContainer();

    @Nonnull
    public ResourceLocation getType();

    @Nonnull
    public ItemStack getContents();

    public void setContents(@Nonnull ItemStack var1);

    public void onContentsChanged();

    default public boolean canEquip(@Nonnull ItemStack stack) {
        return stack.getCapability(ExtensionSlotItemCapability.INSTANCE, null).map(extItem -> IExtensionSlot.isAcceptableSlot(this, stack, extItem) && extItem.canEquip(stack, this)).orElse(false);
    }

    default public boolean canUnequip(@Nonnull ItemStack stack) {
        return stack.getCapability(ExtensionSlotItemCapability.INSTANCE, null).map(extItem -> extItem.canUnequip(stack, this) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) <= 0).orElse(true);
    }

    public static boolean isAcceptableSlot(@Nonnull IExtensionSlot slot, @Nonnull ItemStack stack, @Nonnull IExtensionSlotItem extItem) {
        ImmutableSet<ResourceLocation> slots = extItem.getAcceptableSlots(stack);
        return slots.contains((Object)ExtensionSlotItemCapability.ANY_SLOT) || slots.contains((Object)slot.getType());
    }
}

