/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.stoneholm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.thegrimsey.stoneholm.SHConfig;
import net.thegrimsey.stoneholm.SHConfiguredStructures;
import net.thegrimsey.stoneholm.SHStructures;

@Mod(value="stoneholm")
public class Stoneholm {
    public static final String MODID = "stoneholm";
    public static final HashSet<Biome.Category> SPAWNABLE_BIOME_CATEGORIES = Stream.of(Biome.Category.FOREST, Biome.Category.JUNGLE, Biome.Category.DESERT, Biome.Category.PLAINS, Biome.Category.SAVANNA).collect(Collectors.toCollection(HashSet::new));
    public static SHConfig CONFIG;

    public Stoneholm() {
        AutoConfig.register(SHConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SHConfig)AutoConfig.getConfigHolder(SHConfig.class).getConfig();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SHStructures.STRUCTURE_DEFERRED_REGISTER.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        if (Stoneholm.CONFIG.disableVanillaVillages) {
            forgeBus.addListener(EventPriority.NORMAL, this::removeVanillaVillages);
        }
    }

    void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SHStructures.registerStructureFeatures();
            SHConfiguredStructures.registerConfiguredStructures();
        });
    }

    void biomeModification(BiomeLoadingEvent event) {
        if (SPAWNABLE_BIOME_CATEGORIES.contains(event.getCategory())) {
            event.getGeneration().getStructures().add(() -> SHConfiguredStructures.CONFIGURED_UNDERGROUND_VILLAGE);
        }
    }

    void removeVanillaVillages(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.keySet().remove(Structure.field_236381_q_);
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

