/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.HitBoxData;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.block.BlockPlatformFloor;
import shetiphian.platforms.common.block.BlockPlatformRamp;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRise;

public abstract class BlockPlatformBase
extends Block
implements IColored,
IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208130_ae;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected final EnumPlatformType platformType;
    protected static Table<String, Direction, VoxelShape> HITBOXES = HashBasedTable.create();
    private static Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();
    private static final Material materialPlatform = new Material(MaterialColor.field_151663_o, false, false, true, false, false, false, PushReaction.IGNORE);
    private static final Cache<Entity, BlockPos> WALK_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.SECONDS).build();

    public BlockPlatformBase(EnumPlatformType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)materialPlatform).func_200947_a(SoundType.field_185848_a).func_200948_a(3.0f, 0.5f).func_200944_c().func_226896_b_());
        this.platformType = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LEVEL, WATERLOGGED});
        if (this.getPropertySubType() != null) {
            builder.func_206894_a(new Property[]{this.getPropertySubType()});
        }
    }

    @Nullable
    protected abstract PropertySubType getPropertySubType();

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public Collection<EnumSubType> getAllowedValues() {
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return ImmutableSet.of((Object)((Object)EnumSubType.NONE));
        }
        return propertySubType.func_177700_c();
    }

    public EnumSubType getPlatformSubType(BlockState state) {
        BlockPlatformBase block;
        PropertySubType propertySubType;
        if (state.func_177230_c() instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)state.func_177230_c()).getPropertySubType()) != null) {
            return (EnumSubType)((Object)state.func_177229_b((Property)propertySubType));
        }
        return EnumSubType.NONE;
    }

    public static BlockState getStateWithPlatformSubType(BlockState state, EnumSubType subType) {
        Collection subTypes;
        BlockPlatformBase block;
        PropertySubType propertySubType;
        if (subType != null && subType != EnumSubType.NONE && state.func_177230_c() instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)state.func_177230_c()).getPropertySubType()) != null && (subTypes = propertySubType.func_177700_c()).contains((Object)subType)) {
            return (BlockState)state.func_206870_a((Property)propertySubType, (Comparable)((Object)subType));
        }
        return state;
    }

    public static boolean setPlatformSubType(IWorld world, BlockPos pos, EnumSubType subType) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockPlatformBase) {
            BlockPlatformBase block = (BlockPlatformBase)state.func_177230_c();
            BlockState result = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            if (result != state && Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)result, (boolean)true)) {
                TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
                if (tile instanceof TileEntityPlatformRamp) {
                    block.editLinkedRail(result, world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    block.editLinkedRail(result, world, pos, tile, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.getPlatformType()) {
            case FLAT: {
                return new TileEntityPlatformFlat();
            }
            case RAMP: {
                return new TileEntityPlatformRamp();
            }
            case FLOOR: {
                return new TileEntityPlatformFloor();
            }
            case FRAME: {
                return new TileEntityPlatformFrame();
            }
            case RAIL: 
            case RISE: {
                return new TileEntityPlatformRise();
            }
        }
        return null;
    }

    protected static TileEntityPlatformBase getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        float value = state.func_185887_b(world, pos);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            try {
                Block block = ((BlockItem)tile.getFrameTextureBlock().func_77973_b()).func_179223_d();
                value = block.func_176223_P().func_185887_b(world, pos);
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / value / (float)i;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.platformType.isAddon();
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null) {
            return tile.getSoundType();
        }
        return super.func_220072_p(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        EnumSubType subType = this.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        String cacheKey = "collision:" + this.platformType.getName() + ":" + subType.name() + ":" + direction.func_176742_j();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.getName();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, true);
            if (result == null) {
                return VoxelShapes.func_197880_a();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        EnumSubType subType = this.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        String cacheKey = this.platformType.getName() + ":" + subType.name() + ":" + direction.func_176742_j();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.getName();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, false);
            if (result == null) {
                return VoxelShapes.func_197868_b();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    protected static void addHitBoxData(String key, double[][] cordsets) {
        Map map = HitBoxData.build((double[][])cordsets, (boolean)false);
        map.forEach((direction, shape) -> {
            VoxelShape cfr_ignored_0 = (VoxelShape)HITBOXES.put((Object)key, direction, shape);
        });
    }

    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        return null;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntityPlatformBase oTile;
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile instanceof TileEntityPlatformFrame && ((torch = ((TileEntityPlatformFrame)tile).getTorch()) == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON)) {
            world.func_195593_d(pos, (Block)this);
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                world.func_195593_d(pos.func_177984_a(), (Block)this);
            }
        }
        if (tile != null && (this.platformType == EnumPlatformType.RAMP || this.platformType == EnumPlatformType.FLOOR) && tile.hasRail()) {
            world.func_217377_a(pos.func_177984_a(), false);
        }
        if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinked() && (oTile = BlockPlatformBase.getTile((IBlockReader)world, pos.func_177977_b())) != null) {
            oTile.removeRail();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_217377_a(pos, false);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntityPlatformBase) {
            ((TileEntityPlatformBase)tile).addExtraDrops(drops);
        }
        return drops;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (player == null || !player.func_213453_ef()) {
            return;
        }
        ItemStack currentItem = player.func_184614_ca();
        if (currentItem.func_190926_b()) {
            return;
        }
        if (!currentItem.func_77973_b().getToolTypes(currentItem).contains(Values.WRENCH)) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAIL || this.platformType == EnumPlatformType.RISE) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile == null || !TileHelper.hasRail(tile) && !TileHelper.hasTorch(tile)) {
            return;
        }
        ItemStack stack = null;
        if (this.platformType == EnumPlatformType.FRAME) {
            EnumTorchType torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile.hasRail()) {
            stack = tile.getRailItem();
        }
        if (stack != null) {
            Function.giveItem((PlayerEntity)player, (ItemStack)stack);
            if (this.platformType == EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.func_195593_d(pos, (Block)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformRamp) {
                    this.editLinkedRail(state, (IWorld)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (IWorld)world, pos, tile, false);
                }
            }
            Function.syncTile((TileEntity)tile);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return ActionResultType.PASS;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile == null) {
            return ActionResultType.FAIL;
        }
        boolean isGlowstone = TagHelper.isItemInTag((ItemStack)heldItem, (String)"forge:dusts/glowstone");
        if (heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) || heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || isGlowstone) {
            if (this.platformType == EnumPlatformType.FRAME) {
                EnumTorchType torch;
                boolean placed = false;
                if (!TileHelper.hasTorch(tile) && !isGlowstone) {
                    placed = heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) ? TileHelper.setTorch(tile, this.isPowered((IWorldReader)world, pos) ? EnumTorchType.REDSTONE_OFF : EnumTorchType.REDSTONE_ON) : TileHelper.setTorch(tile, EnumTorchType.LIGHT);
                } else if (isGlowstone && (torch = TileHelper.getTorch(tile)) != null) {
                    switch (torch) {
                        case REDSTONE_OFF: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                            break;
                        }
                        case REDSTONE_ON: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                            break;
                        }
                        case LIGHT: {
                            placed = TileHelper.setTorch(tile, EnumTorchType.GLOWSTONE);
                        }
                    }
                }
                if (placed) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    world.func_184133_a(player, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    world.func_195593_d(pos, (Block)this);
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                        world.func_195593_d(pos.func_177984_a(), (Block)this);
                    }
                    Function.syncTile((TileEntity)tile);
                    return ActionResultType.SUCCESS;
                }
            }
            return ActionResultType.FAIL;
        }
        if (heldItem.func_77973_b() instanceof ItemBlockPlatform && ((ItemBlockPlatform)heldItem.func_77973_b()).getPlatformType().isAddon() && BlockPlatformBase.canPlaceRailOn(state, (IWorldReader)world, pos, tile) && TileHelper.setRail(tile, heldItem)) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            if (tile.hasRail()) {
                world.func_184133_a(player, pos, tile.getRailSound().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                Function.syncTile((TileEntity)tile);
                if (tile instanceof TileEntityPlatformRamp) {
                    this.editLinkedRail(state, (IWorld)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (IWorld)world, pos, tile, false);
                }
                return ActionResultType.SUCCESS;
            }
        }
        if ((Integer)state.func_177229_b((Property)LEVEL) > 0 && heldItem.func_77973_b().getToolTypes(heldItem).contains(ToolType.SHOVEL)) {
            int level = (Integer)state.func_177229_b((Property)LEVEL);
            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
            tile.playLevelTextureSound(player, false);
            if (level <= 1) {
                tile.resetLevelTexture();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static boolean canPlaceRailOn(BlockState state, IWorldReader world, BlockPos pos, TileEntityPlatformBase tile) {
        if (!tile.hasRail() && state.func_177230_c() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.func_177230_c()).platformType;
            EnumSubType subType = ((BlockPlatformBase)state.func_177230_c()).getPlatformSubType(state);
            if (tile instanceof TileEntityPlatformFlat || tile instanceof TileEntityPlatformFloor) {
                return subType.supportsRail(type);
            }
            if (tile instanceof TileEntityPlatformRamp && subType.supportsRail(type)) {
                BlockState stateUp = world.func_180495_p(pos.func_177984_a());
                return stateUp.func_185904_a().func_76222_j();
            }
        }
        return false;
    }

    private void editLinkedRail(BlockState state, IWorld world, BlockPos pos, TileEntityPlatformBase tile, boolean isRamp) {
        if (state.func_177230_c() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.func_177230_c()).platformType;
            EnumSubType subType = ((BlockPlatformBase)state.func_177230_c()).getPlatformSubType(state);
            BlockPos posUp = pos.func_177984_a();
            BlockState above = world.func_180495_p(posUp);
            if (subType.supportsRail(type) && tile.hasRail()) {
                TileEntityPlatformBase oTile;
                BlockState oState;
                if (above.func_177230_c() != this && above.func_185904_a().func_76222_j()) {
                    EnumPlatformType platform = tile.getRailType();
                    if (platform == null) {
                        return;
                    }
                    Function.setBlock((IWorld)world, (BlockPos)posUp, (BlockState)Values.blocksPlatform.get((Object)platform).func_176223_P(), (boolean)false);
                }
                if ((oState = world.func_180495_p(posUp)).func_177230_c() instanceof BlockPlatformBase) {
                    oState = BlockPlatformBase.getStateWithPlatformSubType(oState, EnumSubType.byName(subType.getStyle()));
                    Function.setBlock((IWorld)world, (BlockPos)posUp, (BlockState)((BlockState)oState.func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))), (boolean)true);
                }
                if ((oTile = BlockPlatformBase.getTile((IBlockReader)world, posUp)) instanceof TileEntityPlatformRise) {
                    oTile.setTextureInfo(tile.getRailItem());
                    if (isRamp) {
                        ((TileEntityPlatformRise)oTile).setLinkedToRamp(true);
                    } else {
                        ((TileEntityPlatformRise)oTile).setLinkedToFloor(true);
                    }
                    Function.syncTile((TileEntity)oTile);
                }
            } else {
                TileEntityPlatformBase oTile = BlockPlatformBase.getTile((IBlockReader)world, posUp);
                if (oTile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)oTile).isLinked()) {
                    world.func_217377_a(posUp, false);
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        if (!(this instanceof BlockPlatformType.Singles)) {
            BlockState oState;
            boolean zAxis;
            EnumSubType subType = null;
            Direction face = context.func_196000_l();
            boolean bl = zAxis = direction.func_176740_k() == Direction.Axis.Z;
            if ((this instanceof BlockPlatformType.Walkways && face.func_176740_k() != Direction.Axis.Y || this instanceof BlockPlatformType.Railings) && (oState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(face.func_176734_d()))).func_177230_c() instanceof BlockPlatformBase) {
                BlockPlatformBase oBlock = (BlockPlatformBase)oState.func_177230_c();
                if (oBlock.platformType == this.platformType) {
                    state = (BlockState)state.func_206870_a((Property)FACING, oState.func_177229_b((Property)FACING));
                    subType = this.getPlatformSubType(oState);
                } else if (face == Direction.UP && this instanceof BlockPlatformType.Railings) {
                    subType = EnumSubType.byName(this.getPlatformSubType(oState).getStyle());
                    if (subType.supportsRail(oBlock.platformType)) {
                        state = (BlockState)state.func_206870_a((Property)FACING, oState.func_177229_b((Property)FACING));
                    } else {
                        subType = null;
                    }
                }
            }
            if (subType == null) {
                boolean railOnStep = false;
                if (this instanceof BlockPlatformType.Railings) {
                    double hitX = context.func_221532_j().field_72450_a - (double)context.func_195995_a().func_177958_n();
                    double hitZ = context.func_221532_j().field_72449_c - (double)context.func_195995_a().func_177952_p();
                    BlockState down = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
                    if (down.func_177230_c() instanceof StairsBlock) {
                        railOnStep = true;
                        direction = (Direction)down.func_177229_b((Property)StairsBlock.field_176309_a);
                        subType = direction.func_176740_k() == Direction.Axis.Z ? (direction == Direction.NORTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT)) : (direction == Direction.EAST ? (hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                    } else {
                        if (face.func_176740_k() == Direction.Axis.Y) {
                            if (hitX <= 0.5 && hitZ < 0.5) {
                                direction = hitX < hitZ ? Direction.NORTH : Direction.EAST;
                            } else if (hitX > 0.5 && hitZ <= 0.5) {
                                direction = 1.0 - hitX < hitZ ? Direction.SOUTH : Direction.EAST;
                            } else if (hitX <= 0.5 && hitZ > 0.5) {
                                direction = hitX < 1.0 - hitZ ? Direction.NORTH : Direction.WEST;
                            } else if (hitX > 0.5 && hitZ >= 0.5) {
                                direction = hitX > hitZ ? Direction.SOUTH : Direction.WEST;
                            }
                        } else {
                            direction = face.func_176735_f();
                        }
                        subType = EnumSubType.EDGE;
                    }
                    state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
                } else if (zAxis) {
                    double hitX = context.func_221532_j().field_72450_a - (double)context.func_195995_a().func_177958_n();
                    subType = hitX > (double)0.4f && hitX < (double)0.6f ? EnumSubType.MIDDLE : (direction == Direction.SOUTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                } else {
                    double hitZ = context.func_221532_j().field_72449_c - (double)context.func_195995_a().func_177952_p();
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        subType = EnumSubType.MIDDLE;
                    } else if (direction == Direction.WEST) {
                        subType = hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT;
                    } else {
                        EnumSubType enumSubType = subType = hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT;
                    }
                }
                if (!railOnStep && this.platformType != EnumPlatformType.RAMP) {
                    if (subType == EnumSubType.RIGHT) {
                        state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction.func_176734_d());
                        EnumSubType enumSubType = subType = this.platformType.isAddon() ? EnumSubType.EDGE : EnumSubType.EDGE_S;
                    }
                    if (subType == EnumSubType.LEFT) {
                        subType = EnumSubType.EDGE;
                    }
                }
            }
            state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
        }
        return (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null) {
            tile.setTextureInfo(stack);
            Function.syncTile((TileEntity)tile);
        }
        this.updateBlock(state, world, pos);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            this.updateBlock(newState, world, pos);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, EntityType<?> entityType) {
        return false;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        if (world.field_72995_K || !((Boolean)Configuration.DUST_COVERING.isEnvironmentReactive.get()).booleanValue() || !(state.func_177230_c() instanceof BlockPlatformBase) || ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null) {
            int level = (Integer)state.func_177229_b((Property)LEVEL);
            Biome biome = world.func_226691_t_(pos);
            boolean canIncreaseLevel = this.canIncreaseLevel(tile, biome, level);
            if (world.func_72896_J()) {
                switch (biome.func_201851_b()) {
                    case NONE: {
                        if (!world.func_72911_I() || !canIncreaseLevel || !this.getChance(world.field_73012_v, (Integer)Configuration.DUST_COVERING.chanceSandStorm.get()) || !this.isSandBiome((World)world, pos) || !this.isOutdoors((World)world, pos, true)) break;
                        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level + 1))), (boolean)true);
                        break;
                    }
                    case RAIN: {
                        if ((double)biome.func_225486_c(pos) >= 0.2) {
                            if (!world.func_72911_I() || level <= 0 || !this.getChance(world.field_73012_v, (Integer)Configuration.DUST_COVERING.chanceRainWash.get()) || !this.isSandBiome((World)world, pos) || !this.isOutdoors((World)world, pos, false)) break;
                            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
                            if (level > 1) break;
                            tile.resetLevelTexture();
                            break;
                        }
                    }
                    case SNOW: {
                        if (!canIncreaseLevel || !this.getChance(world.field_73012_v, (Integer)Configuration.DUST_COVERING.chanceSnow.get()) || !this.isOutdoors((World)world, pos, false)) break;
                        Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level + 1))), (boolean)true);
                    }
                }
            } else if (canIncreaseLevel && level == 0 && this.getChance(world.field_73012_v, (Integer)Configuration.DUST_COVERING.chanceSand.get()) && this.isSandBiome((World)world, pos) && this.isOutdoors((World)world, pos, true)) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(1))), (boolean)true);
            }
        }
    }

    private boolean canIncreaseLevel(TileEntityPlatformBase tile, Biome biome, int level) {
        if (level < 3) {
            Block layerTextureBlock = tile.getLayerTextureBlock();
            Block biomeLayerTexture = tile.getBiomeLayerTexture(biome);
            if (level == 0 && layerTextureBlock != biomeLayerTexture) {
                tile.resetLevelTexture();
                layerTextureBlock = tile.getLayerTextureBlock();
            }
            if (layerTextureBlock == Blocks.field_150350_a) {
                return tile.setLevelTexture(new ItemStack((IItemProvider)biomeLayerTexture));
            }
            return biomeLayerTexture == layerTextureBlock;
        }
        return false;
    }

    private boolean getChance(Random random, int odds) {
        return odds > 0 && random.nextInt(odds) == 0;
    }

    private boolean isSandBiome(World world, BlockPos pos) {
        return world.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a().func_177230_c() instanceof SandBlock;
    }

    private boolean isOutdoors(World world, BlockPos pos, boolean addingSand) {
        if (addingSand) {
            BlockPos.Mutable mPos = new BlockPos.Mutable();
            int layers = 0;
            boolean isRaining = world.func_72896_J();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x == 0 && z == 0 && y == 0) continue;
                        mPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                        if (world.func_175623_d((BlockPos)mPos)) continue;
                        BlockState state = world.func_180495_p((BlockPos)mPos);
                        Block block = state.func_177230_c();
                        if (block instanceof BlockPlatformBase) {
                            if (y < 0 && !isRaining) continue;
                            layers += Math.max(0, (Integer)state.func_177229_b((Property)LEVEL) - 1);
                            continue;
                        }
                        if (!BlockTags.field_203436_u.func_230235_a_((Object)block)) continue;
                        return true;
                    }
                }
            }
            return layers > 3;
        }
        if (world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p()) <= pos.func_177956_o() + 1) {
            return true;
        }
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                mPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
                if (world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, mPos.func_177958_n(), mPos.func_177952_p()) > pos.func_177956_o() + 1) continue;
                return true;
            }
        }
        return false;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        BlockPos cached;
        TileEntityPlatformBase tile;
        super.func_176199_a(world, pos, entity);
        if (!(world.field_72995_K || !((Boolean)Configuration.DUST_COVERING.isEntityReactive.get()).booleanValue() || (tile = BlockPlatformBase.getTile((IBlockReader)world, pos)) == null || (cached = (BlockPos)WALK_CACHE.getIfPresent((Object)entity)) != null && cached.equals((Object)pos))) {
            BlockState state = world.func_180495_p(pos);
            int level = (Integer)state.func_177229_b((Property)LEVEL);
            if (level > 0 && world.func_201674_k().nextInt(4) == 0) {
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(level - 1))), (boolean)true);
                if (level <= 1) {
                    tile.resetLevelTexture();
                }
            }
            WALK_CACHE.put((Object)entity, (Object)pos);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        this.updateBlock(state, world, pos);
    }

    private void updateBlock(BlockState state, World world, BlockPos pos) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile == null) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAMP) {
            BlockPos posForward;
            BlockState stateForward;
            AxisAlignedBB aabbDown;
            BlockState stateDown;
            Block blockDown;
            int altSupport = world.func_175623_d(pos.func_177977_b()) ? 2 : ((blockDown = (stateDown = world.func_180495_p(pos.func_177977_b())).func_177230_c()) instanceof FenceBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.func_196954_c((IBlockReader)world, pos.func_177977_b()))) != null && aabbDown.field_72337_e >= 1.0 ? (aabbDown.field_72340_a > 0.0625 || aabbDown.field_72339_c > 0.0625 || aabbDown.field_72336_d < 0.9375 || aabbDown.field_72334_f < 0.9375 ? 1 : 0) : 2));
            if (!world.func_175623_d(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))) && !(stateForward = world.func_180495_p(posForward = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)))).func_185904_a().func_76222_j()) {
                AxisAlignedBB aabbForward = this.getShapeBoundingBox(stateForward.func_196954_c((IBlockReader)world, posForward));
                AxisAlignedBB aabb = this.getShapeBoundingBox(state.func_196954_c((IBlockReader)world, pos));
                altSupport += aabb != null && aabbForward != null && aabb.func_186670_a(pos).func_72326_a(aabbForward.func_186670_a(posForward).func_186662_g(0.1)) ? 3 : 0;
            }
            TileHelper.setAltSupport(tile, altSupport);
            if (tile instanceof TileEntityPlatformRamp) {
                Direction facing;
                boolean extLeft = false;
                boolean extRight = false;
                EnumSubType subType = (EnumSubType)((Object)state.func_177229_b((Property)BlockPlatformType.Ramps.SUBTYPE));
                if (subType == EnumSubType.INSIDE) {
                    facing = (Direction)state.func_177229_b((Property)FACING);
                    BlockState check = world.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
                    extLeft = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.func_177229_b((Property)FACING)).equals((Object)facing) && ((EnumSubType)((Object)check.func_177229_b((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                    check = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
                    extRight = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.func_177229_b((Property)FACING)).equals((Object)facing.func_176746_e()) && ((EnumSubType)((Object)check.func_177229_b((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                } else if (subType == EnumSubType.OUTSIDE) {
                    facing = (Direction)state.func_177229_b((Property)FACING);
                    BlockState check = world.func_180495_p(pos.func_177972_a(facing));
                    extLeft = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.func_177229_b((Property)FACING)).equals((Object)facing.func_176746_e()) && ((EnumSubType)((Object)check.func_177229_b((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                    check = world.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
                    extRight = BlockPlatformType.Ramps.isRamp(check) && ((Direction)check.func_177229_b((Property)FACING)).equals((Object)facing) && ((EnumSubType)((Object)check.func_177229_b((Property)BlockPlatformType.Ramps.SUBTYPE))).getBase().equals("normal");
                }
                ((TileEntityPlatformRamp)tile).setSupportExtensions(extLeft, extRight);
            }
            Function.syncTile((TileEntity)tile);
        } else if (this.platformType == EnumPlatformType.FLOOR) {
            AxisAlignedBB aabbDown;
            BlockState stateDown;
            Block blockDown;
            int altSupport = world.func_175623_d(pos.func_177977_b()) ? 2 : ((blockDown = (stateDown = world.func_180495_p(pos.func_177977_b())).func_177230_c()) instanceof FenceBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.func_196954_c((IBlockReader)world, pos.func_177977_b()))) != null && aabbDown.field_72337_e >= 1.0 ? (aabbDown.field_72340_a > 0.0625 || aabbDown.field_72339_c > 0.0625 || aabbDown.field_72336_d < 0.9375 || aabbDown.field_72334_f < 0.9375 ? 1 : 0) : 2));
            TileHelper.setAltSupport(tile, altSupport);
            Function.syncTile((TileEntity)tile);
        } else if (this.platformType == EnumPlatformType.FRAME) {
            if (TileHelper.hasTorch(tile)) {
                boolean notify = false;
                EnumTorchType torch = TileHelper.getTorch(tile);
                if (torch == EnumTorchType.REDSTONE_OFF || torch == EnumTorchType.REDSTONE_ON) {
                    if (this.isPowered((IWorldReader)world, pos)) {
                        if (torch != EnumTorchType.REDSTONE_OFF) {
                            TileHelper.setTorch(tile, EnumTorchType.REDSTONE_OFF);
                            notify = true;
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumTorchType.REDSTONE_ON) {
                        TileHelper.setTorch(tile, EnumTorchType.REDSTONE_ON);
                        notify = true;
                        Function.syncTile((TileEntity)tile);
                    }
                } else if (torch == EnumTorchType.LAMP_OFF || torch == EnumTorchType.LAMP_ON) {
                    if (this.isPowered((IWorldReader)world, pos)) {
                        if (torch != EnumTorchType.LAMP_ON) {
                            TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                            notify = true;
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumTorchType.LAMP_OFF) {
                        TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                        notify = true;
                        Function.syncTile((TileEntity)tile);
                    }
                }
                if (notify) {
                    world.func_195593_d(pos, (Block)this);
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                        world.func_195593_d(pos.func_177984_a(), (Block)this);
                    }
                }
            }
        } else if (this.platformType.isAddon()) {
            TileEntityPlatformBase oTile = BlockPlatformBase.getTile((IBlockReader)world, pos.func_177977_b());
            if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinkedToRamp() && !(oTile instanceof TileEntityPlatformRamp)) {
                world.func_217377_a(pos, false);
            }
            if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinkedToFloor() && !(oTile instanceof TileEntityPlatformFloor)) {
                world.func_217377_a(pos, false);
            }
        }
    }

    private AxisAlignedBB getShapeBoundingBox(VoxelShape shape) {
        return shape.func_197766_b() ? null : shape.func_197752_a();
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return this.rotateBlock(state, world, pos, BlockPlatformBase.getTile((IBlockReader)world, pos), rotation);
    }

    public BlockState rotateBlock(BlockState state, IWorld world, BlockPos pos, TileEntityPlatformBase tile, Rotation rotation) {
        if (tile == null) {
            return state;
        }
        if (tile instanceof TileEntityPlatformRise && ((TileEntityPlatformRise)tile).isLinked()) {
            BlockState newStateDown;
            BlockPos posDown = pos.func_177977_b();
            BlockState stateDown = world.func_180495_p(posDown);
            if ((stateDown.func_177230_c() instanceof BlockPlatformFloor || stateDown.func_177230_c() instanceof BlockPlatformRamp) && stateDown != (newStateDown = stateDown.rotate(world, posDown, rotation))) {
                Function.setBlock((IWorld)world, (BlockPos)posDown, (BlockState)newStateDown, (boolean)true);
            }
            return world.func_180495_p(pos);
        }
        if (this.platformType == EnumPlatformType.FRAME && rotation == Rotation.NONE) {
            rotation = Rotation.CLOCKWISE_90;
        }
        if (rotation != Rotation.NONE) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            switch (rotation) {
                case CLOCKWISE_90: {
                    direction = direction.func_176746_e();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    direction = direction.func_176735_f();
                    break;
                }
                case CLOCKWISE_180: {
                    direction = direction.func_176734_d();
                }
            }
            BlockState rotatedState = (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction);
            if (tile.hasRail() && (tile instanceof TileEntityPlatformRamp || tile instanceof TileEntityPlatformFloor)) {
                this.editLinkedRail(rotatedState, world, pos, tile, tile instanceof TileEntityPlatformRamp);
            }
            return rotatedState;
        }
        EnumSubType subType = this.getPlatformSubType(state);
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return state;
        }
        ArrayList<EnumSubType> subTypes = propertySubType.func_177700_c();
        if (tile.hasRail() || this.platformType.isAddon()) {
            ArrayList<EnumSubType> railSupport = new ArrayList<EnumSubType>();
            for (EnumSubType type : subTypes) {
                switch (type.getStyleType()) {
                    case NONE: 
                    case MIDDLE: {
                        break;
                    }
                    case INSIDE: 
                    case OUTSIDE: 
                    case EDGE: {
                        if (tile instanceof TileEntityPlatformRamp) break;
                    }
                    default: {
                        railSupport.add(type);
                    }
                }
            }
            subTypes = railSupport;
        }
        EnumSubType newType = null;
        EnumSubType[] types = subTypes.toArray(new EnumSubType[0]);
        int current = 100;
        for (int index = 0; index < types.length; ++index) {
            if (types[index] == subType) {
                current = index;
            }
            if (current >= index) continue;
            newType = types[index];
            break;
        }
        if (newType == null && current > 0) {
            newType = types[0];
        }
        if (newType != null && BlockPlatformBase.setPlatformSubType(world, pos, newType)) {
            return world.func_180495_p(pos);
        }
        return state;
    }

    private boolean isPowered(IWorldReader world, BlockPos pos) {
        if (world.func_175627_a(pos.func_177977_b(), Direction.DOWN) > 0) {
            return true;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos.func_177972_a(facing));
            if (TileHelper.hasTorch(tile) || world.func_175627_a(pos.func_177972_a(facing), facing) <= 1) continue;
            return true;
        }
        return false;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side == Direction.DOWN ? this.func_180656_a(state, world, pos, side) : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader world, BlockPos pos, Direction side) {
        TileEntityPlatformBase tile;
        if (side != Direction.UP && this.platformType == EnumPlatformType.FRAME && (tile = BlockPlatformBase.getTile(world, pos)) != null) {
            EnumTorchType torch = TileHelper.getTorch(tile);
            return torch == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON ? (side == Direction.DOWN ? 15 : 1) : 0;
        }
        return 0;
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.PICKAXE || tool == ToolType.AXE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null && !(stack = tile.getFrameTextureBlock()).func_190926_b() && stack.func_77973_b() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)world)).func_196958_f()) {
            return ParticleHelper.addDestroyEffects((BlockState)state, (World)((ClientWorld)world), (BlockPos)pos, (ParticleManager)manager, (BlockState)particles);
        }
        return false;
    }

    public boolean addLandingEffects(BlockState state, ServerWorld world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).func_190926_b() && stack.func_77973_b() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)world)).func_196958_f()) {
            return ParticleHelper.addLandingEffects((ServerWorld)world, (Entity)entity, (int)numberOfParticles, (BlockState)particles);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).func_190926_b() && stack.func_77973_b() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)world)).func_196958_f()) {
            return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (BlockState)particles);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target instanceof BlockRayTraceResult) {
            BlockState particles;
            ItemStack stack;
            BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
            Direction direction = ((BlockRayTraceResult)target).func_216354_b();
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((IBlockReader)world, pos);
            if (tile != null && !(stack = tile.getFrameTextureBlock()).func_190926_b() && stack.func_77973_b() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (World)world)).func_196958_f()) {
                return ParticleHelper.addHitEffects((BlockState)state, (World)((ClientWorld)world), (BlockPos)pos, (Direction)direction, (ParticleManager)manager, (BlockState)particles);
            }
        }
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityPlatformBase tile;
        if (index > 0 && index < 5 && data.world != null && data.pos != null && (tile = BlockPlatformBase.getTile((IBlockReader)data.world, data.pos)) != null) {
            if (this.platformType.isAddon()) {
                index -= 2;
            }
            return tile.getTint(index - 1);
        }
        return 0xFFFFFF;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((IItemProvider)this);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            if (target != null && target.subHit > 0 && TileHelper.hasRail(tile)) {
                return tile.getRailItem();
            }
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((IItemProvider)this);
    }
}

