/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformFrame
extends BlockPlatformType.Singles {
    public BlockPlatformFrame() {
        super(EnumPlatformType.FRAME);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile(world, pos);
        if (tile != null && (torch = TileHelper.getTorch(tile)) != null) {
            switch (torch) {
                case REDSTONE_ON: {
                    return Blocks.field_150429_aA.func_176223_P().func_185906_d();
                }
                case LIGHT: {
                    return Blocks.field_150478_aa.func_176223_P().func_185906_d();
                }
                case GLOWSTONE: {
                    return Blocks.field_150426_aN.func_176223_P().func_185906_d();
                }
                case LAMP_ON: {
                    return ((BlockState)Blocks.field_150379_bu.func_176223_P().func_206870_a((Property)RedstoneLampBlock.field_196502_a, (Comparable)Boolean.valueOf(true))).func_185906_d();
                }
            }
        }
        return super.getLightValue(state, world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile((IBlockReader)world, pos);
        if (TileHelper.hasTorch(tile) && (torch = TileHelper.getTorch(tile)) != null) {
            double x = (float)pos.func_177958_n() + 0.5f;
            double y = (float)pos.func_177956_o() + 0.75f;
            double z = (float)pos.func_177952_p() + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, x += (double)(rand.nextFloat() - 0.5f) * 0.2, y += (double)(rand.nextFloat() - 0.5f) * 0.2, z += (double)(rand.nextFloat() - 0.5f) * 0.2, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHT: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

